/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;

public class ProtocolSample
implements Serializable {
    private final long timestamp;
    private final short protocolId;
    private final String protocolName;
    private final List<MetricSample> metricSamples;
    @JsonIgnore
    private final Map<String, MetricSample> metricSampleMap;

    public ProtocolSample(long timestamp, short protocolId, String protocolName, List<MetricSample> metricSamples) {
        this.timestamp = timestamp;
        this.protocolId = protocolId;
        this.protocolName = protocolName;
        this.metricSamples = metricSamples;
        this.metricSampleMap = new HashMap<String, MetricSample>();
        for (MetricSample sample : metricSamples) {
            this.metricSampleMap.put(sample.getMetricName(), sample);
        }
    }

    public ProtocolSample(short protocolId, String protocolName, List<MetricSample> metricSamples) {
        this(System.currentTimeMillis(), protocolId, protocolName, metricSamples);
    }

    public void addMetricSample(MetricSample sample) {
        this.metricSamples.add(sample);
        this.metricSampleMap.put(sample.getMetricName(), sample);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public short getProtocolId() {
        return this.protocolId;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public List<MetricSample> getMetricSamples() {
        return this.metricSamples;
    }

    public Map<String, MetricSample> getMetricSampleMap() {
        return this.metricSampleMap;
    }

    public MetricSample getMetricSample(String metricName) {
        return this.metricSampleMap.get(metricName);
    }
}

