/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pt.unl.fct.di.novasys.babel.metrics.LabelValues;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.IncorrectLabelNumberException;

public class Record
extends Metric<Record> {
    private static final int DEFAULT_RECORDS_ESTIMATE = 25;
    private boolean timestampParam;
    private String[] recordParams;
    private List<LabelValues> records;
    private final Object lock = new Object();
    private int numRecordParams;

    protected Record(Builder builder) {
        super(builder);
        this.init(builder.timestampParam, builder.estimatedRecords, builder.recordParams);
    }

    private Record(Record r) {
        super(r);
        this.init(r.timestampParam, 0, r.recordParams);
    }

    public void init(boolean timestampParam, int estimatedRecords, String ... recordParams) {
        this.timestampParam = timestampParam;
        this.recordParams = recordParams;
        this.numRecordParams = this.timestampParam ? recordParams.length - 1 : recordParams.length;
        this.records = new ArrayList<LabelValues>(estimatedRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(String ... parameters) {
        if (this.isDisabled()) {
            return;
        }
        if (this.numRecordParams != parameters.length) {
            throw new IncorrectLabelNumberException();
        }
        String[] recordParamsCopy = Arrays.copyOf(parameters, this.numRecordParams + (this.timestampParam ? 1 : 0));
        if (this.timestampParam) {
            recordParamsCopy[parameters.length] = String.valueOf(System.currentTimeMillis());
        }
        LabelValues lv = new LabelValues(recordParamsCopy);
        Object object = this.lock;
        synchronized (object) {
            this.records.add(lv);
        }
    }

    public static Builder builder(String name, String ... recordParams) {
        return new Builder(name, recordParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetThisMetric() {
        Object object = this.lock;
        synchronized (object) {
            this.records.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MetricSample collectMetric() {
        ArrayList<LabelValues> snapshot;
        Object object = this.lock;
        synchronized (object) {
            snapshot = new ArrayList<LabelValues>(this.records);
        }
        ArrayList<Sample> samples = new ArrayList<Sample>(snapshot.size());
        for (LabelValues lv : snapshot) {
            samples.add(new Sample(0.0, this.recordParams, Arrays.copyOf(lv.getLabelValues(), this.recordParams.length)));
        }
        return this.sampleBuilder().labelNames(Arrays.copyOf(this.recordParams, this.recordParams.length)).build(samples.toArray(new Sample[0]));
    }

    @Override
    protected Record newInstance() {
        return new Record(this);
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        private String[] recordParams;
        private boolean timestampParam = false;
        private int estimatedRecords = 25;

        public Builder(String name, String ... recordParams) {
            super(name, Metric.Unit.NONE, Metric.MetricType.RECORD, new String[0]);
            this.recordParams = Arrays.copyOf(recordParams, recordParams.length);
        }

        public Builder timestampParam() {
            if (this.timestampParam) {
                return this;
            }
            String[] updatedRecordParams = new String[this.recordParams.length + 1];
            System.arraycopy(this.recordParams, 0, updatedRecordParams, 0, this.recordParams.length);
            updatedRecordParams[this.recordParams.length] = "timestamp";
            this.recordParams = updatedRecordParams;
            this.timestampParam = true;
            return this;
        }

        public Builder numberRecordsEstimate(int num) {
            if (num > 0) {
                this.estimatedRecords = num;
            }
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }
}

