/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.Gauge;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;

public class StatsGauge
extends Metric<Gauge> {
    private static final String LABEL_NAME = "stat_type";
    private Map<String, Long> timedEvents;
    private boolean percentilesEnabled;
    private int[] percentiles;
    private volatile double sum;
    private volatile double avg;
    private volatile double min;
    private volatile double max;
    private volatile long count;
    private final Object lock = new Object();
    private volatile double m2;
    private List<Double> valuesRegistered;
    private final StatType[] statTypes;

    protected StatsGauge(Builder builder) {
        super(builder);
        if (builder.percentilesEnabled) {
            this.percentilesEnabled = true;
            this.percentiles = builder.percentiles;
            this.valuesRegistered = new ArrayList<Double>(50);
        }
        this.statTypes = builder.statTypes;
        this.timedEvents = new HashMap<String, Long>();
        this.doubleInits();
    }

    private void doubleInits() {
        this.sum = 0.0;
        this.avg = 0.0;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.count = 0L;
        this.m2 = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(double value) {
        if (this.isDisabled()) {
            return;
        }
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.sum += value;
        ++this.count;
        double delta = value - this.avg;
        this.avg += delta / (double)this.count;
        this.m2 += delta * (value - this.avg);
        if (this.percentilesEnabled) {
            Object object = this.lock;
            synchronized (object) {
                this.valuesRegistered.add(value);
            }
        }
    }

    public void startTimedEvent(String eventID) {
        if (this.isDisabled()) {
            return;
        }
        if (this.timedEvents.containsKey(eventID)) {
            return;
        }
        this.timedEvents.put(eventID, System.currentTimeMillis());
    }

    public void stopTimedEvent(String eventID) {
        if (this.isDisabled()) {
            return;
        }
        if (!this.timedEvents.containsKey(eventID)) {
            return;
        }
        double elapsedTime = System.currentTimeMillis() - this.timedEvents.remove(eventID);
        this.updateStats(elapsedTime);
    }

    public void observe(double value) {
        if (this.isDisabled()) {
            return;
        }
        this.updateStats(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetThisMetric() {
        this.doubleInits();
        if (this.percentilesEnabled) {
            Object object = this.lock;
            synchronized (object) {
                this.valuesRegistered.clear();
            }
        }
    }

    private double calculatePercentile(List<Double> valuesRegistered, int percentile) {
        if (valuesRegistered.isEmpty()) {
            return 0.0;
        }
        int index = (int)Math.ceil((double)percentile / 100.0 * (double)valuesRegistered.size()) - 1;
        return valuesRegistered.get(Math.max(0, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MetricSample collectMetric() {
        Sample[] samples = new Sample[this.statTypes.length + (this.percentilesEnabled ? this.percentiles.length : 0)];
        String[] labelNames = new String[]{LABEL_NAME};
        int index = 0;
        block11: for (StatType statType : this.statTypes) {
            switch (statType.ordinal()) {
                case 4: {
                    samples[index++] = new Sample(this.count, labelNames, new String[]{"count"});
                    continue block11;
                }
                case 0: {
                    samples[index++] = new Sample(this.avg, labelNames, new String[]{"avg"});
                    continue block11;
                }
                case 5: {
                    samples[index++] = new Sample(this.sum, labelNames, new String[]{"sum"});
                }
                case 1: {
                    samples[index++] = new Sample(this.min, labelNames, new String[]{"min"});
                    continue block11;
                }
                case 2: {
                    samples[index++] = new Sample(this.max, labelNames, new String[]{"max"});
                    continue block11;
                }
                case 3: {
                    double stdDev = this.count > 1L ? Math.sqrt(this.m2 / (double)(this.count - 1L)) : 0.0;
                    samples[index++] = new Sample(stdDev, labelNames, new String[]{"std_dev"});
                }
            }
        }
        if (this.percentilesEnabled) {
            ArrayList<Double> valuesRegisteredSnapshot;
            Object object = this.lock;
            synchronized (object) {
                valuesRegisteredSnapshot = new ArrayList<Double>(this.valuesRegistered);
            }
            valuesRegisteredSnapshot.sort(Double::compareTo);
            for (Object percentile : (Object)this.percentiles) {
                double pValue = this.calculatePercentile(valuesRegisteredSnapshot, (int)percentile);
                samples[index++] = new Sample(pValue, labelNames, new String[]{"p" + (int)percentile});
            }
        }
        return this.sampleBuilder().labelNames(labelNames).build(samples);
    }

    @Override
    protected Gauge newInstance() {
        return new Gauge.Builder(this.getName(), this.getUnit(), new String[0]).build();
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        private StatType[] statTypes = new StatType[]{StatType.AVG, StatType.MIN, StatType.MAX};
        private boolean percentilesEnabled = false;
        private int[] percentiles;

        public Builder(String name, Metric.Unit unit) {
            super(name, unit, Metric.MetricType.STATSGAUGE, new String[0]);
        }

        public Builder(String name, String unit) {
            super(name, Metric.Unit.of(unit), Metric.MetricType.STATSGAUGE, new String[0]);
        }

        public Builder statTypes(StatType ... statTypes) {
            HashSet<StatType> statTypeSet = new HashSet<StatType>();
            for (StatType st : statTypes) {
                statTypeSet.add(st);
                if (!st.equals((Object)StatType.AVG)) continue;
                statTypeSet.add(StatType.COUNT);
            }
            this.statTypes = statTypeSet.toArray(new StatType[0]);
            return this;
        }

        public Builder percentiles(int ... percentile) {
            if (percentile == null || percentile.length == 0) {
                throw new IllegalArgumentException("Percentiles cannot be null or empty");
            }
            for (int p : percentile) {
                if (p >= 0 && p <= 100) continue;
                throw new IllegalArgumentException("Percentiles must be between 0 and 100");
            }
            this.percentilesEnabled = true;
            this.percentiles = percentile;
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        public StatsGauge build() {
            return new StatsGauge(this);
        }
    }

    public static enum StatType {
        AVG,
        MIN,
        MAX,
        STD_DEV,
        COUNT,
        SUM;

    }
}

