/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.instant;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.formatting.JSONFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.MetricSampleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.instant.InstantExporter;
import pt.unl.fct.di.novasys.babel.metrics.utils.ClientSocketCommons;

public class InstantClientSocketExporter
implements InstantExporter {
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String TERMINATOR = "TERMINATOR";
    BlockingQueue<MetricSample> toExport;
    Properties properties = this.loadDefaults();
    MetricSampleFormatter formatter;
    Socket socket;
    String exporterName;

    public InstantClientSocketExporter(Properties props, String exporterName) {
        this.properties.putAll((Map<?, ?>)props);
        this.formatter = new JSONFormatter();
        this.exporterName = exporterName;
        this.toExport = new LinkedBlockingQueue<MetricSample>();
    }

    @Override
    public String getExporterName() {
        return this.exporterName;
    }

    protected Properties loadDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty(TERMINATOR, "\n");
        return defaults;
    }

    public void setFormatter(MetricSampleFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void addMetricSample(MetricSample ms) {
        this.toExport.add(ms);
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        ClientSocketCommons.HostPort hostPort;
        try {
            hostPort = ClientSocketCommons.parseHostPort(this.properties);
        }
        catch (ClientSocketCommons.IncorrectHostPortException e) {
            throw new RuntimeException(e);
        }
        this.socket = ClientSocketCommons.connect(hostPort.host, hostPort.port);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (true) {
            try {
                while (true) {
                    MetricSample s2 = this.toExport.take();
                    osw.write(this.formatter.format(s2));
                    osw.write(this.properties.getProperty(TERMINATOR));
                    osw.flush();
                }
            }
            catch (IOException | NullPointerException e) {
                this.socket = ClientSocketCommons.connect(hostPort.host, hostPort.port);
                try {
                    osw = new OutputStreamWriter(this.socket.getOutputStream());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

