/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;

public class AggregationInput {
    private final Map<MetricIdentifier, Map<String, MetricSample>> samplesPerHost = new HashMap<MetricIdentifier, Map<String, MetricSample>>();
    private final Map<MetricIdentifier, List<MetricSample>> samplesList = new HashMap<MetricIdentifier, List<MetricSample>>();

    public Map<String, MetricSample> getSamplesIndexedPerHost(short protocol, String metricName) {
        return this.samplesPerHost.getOrDefault(new MetricIdentifier(metricName, protocol), new HashMap());
    }

    public List<MetricSample> getSamples(short protocol, String metricName) {
        return this.samplesList.getOrDefault(new MetricIdentifier(metricName, protocol), new LinkedList());
    }

    public int getNumberOfHostsForMetric(short protocol, String metricName) {
        Map<String, MetricSample> samples = this.samplesPerHost.get(new MetricIdentifier(metricName, protocol));
        if (samples == null) {
            return 0;
        }
        return samples.size();
    }

    public Map<MetricIdentifier, Map<String, MetricSample>> getSamplesPerHost() {
        return this.samplesPerHost;
    }

    public Map<MetricIdentifier, List<MetricSample>> getSamplesList() {
        return this.samplesList;
    }

    public List<MetricIdentifier> getMetrics() {
        return List.copyOf(this.samplesPerHost.keySet());
    }

    protected void addMetricSample(String host, MetricIdentifier metric, MetricSample sample) {
        if (!this.samplesPerHost.containsKey(metric)) {
            this.samplesPerHost.put(metric, new HashMap());
        }
        this.samplesPerHost.get(metric).put(host, sample);
        if (!this.samplesList.containsKey(metric)) {
            this.samplesList.put(metric, new LinkedList());
        }
        this.samplesList.get(metric).add(sample);
    }
}

