/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationInput;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationResult;
import pt.unl.fct.di.novasys.babel.metrics.monitor.HostProtocolIdentifier;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;

public class AggregationManager {
    private static final Logger logger = LogManager.getLogger(AggregationManager.class);
    private final Map<MetricIdentifier, Map<String, MetricSample>> samples = new ConcurrentHashMap<MetricIdentifier, Map<String, MetricSample>>();
    private final List<Aggregation> aggregationsToPerform = new LinkedList<Aggregation>();
    private final Set<MetricIdentifier> metricsNotAggregated = new HashSet<MetricIdentifier>();
    private final Set<MetricIdentifier> metricsBelongingToAggregation = new HashSet<MetricIdentifier>();
    private final Map<Short, String> protocolIdsToNames = new ConcurrentHashMap<Short, String>();
    private final Map<MetricIdentifier, Integer> metricSampleCounts = new ConcurrentHashMap<MetricIdentifier, Integer>();
    private boolean retainUnaggregatedMetrics = true;
    private ExecutorService executor;
    private int nSamplesReceived = 0;

    public Map<MetricIdentifier, Map<String, MetricSample>> getSamples() {
        return this.samples;
    }

    public List<Aggregation> getAggregationsToPerform() {
        return this.aggregationsToPerform;
    }

    public Set<MetricIdentifier> getMetricsNotAggregated() {
        return this.metricsNotAggregated;
    }

    public Set<MetricIdentifier> getMetricsBelongingToAggregation() {
        return this.metricsBelongingToAggregation;
    }

    public int getMetricSampleCount(short protocolId, String metricName) {
        MetricIdentifier mi = new MetricIdentifier(metricName, protocolId);
        return this.metricSampleCounts.getOrDefault(mi, 0);
    }

    public int numberOfHostsIncludedNextAggregation() {
        return this.nSamplesReceived;
    }

    public synchronized void addSample(String host, NodeSample sample) {
        ++this.nSamplesReceived;
        for (Map.Entry<Short, ProtocolSample> entry : sample.getSamplesPerProtocol().entrySet()) {
            this.protocolIdsToNames.put(entry.getKey(), entry.getValue().getProtocolName());
            for (MetricSample metricEntry : entry.getValue().getMetricSamples()) {
                MetricIdentifier identifier = new MetricIdentifier(metricEntry.getMetricName(), entry.getKey());
                if (!this.metricsBelongingToAggregation.contains(identifier)) {
                    this.metricsNotAggregated.add(identifier);
                }
                if (!this.samples.containsKey(identifier)) {
                    this.samples.put(identifier, new HashMap());
                }
                this.samples.get(identifier).put(host, metricEntry);
            }
        }
    }

    public synchronized void addAggregation(Aggregation aggregation) {
        this.aggregationsToPerform.add(aggregation);
        for (MetricIdentifier mi : aggregation.getMetricIdentifiers()) {
            this.metricsBelongingToAggregation.add(mi);
            this.metricsNotAggregated.remove(mi);
        }
    }

    public Map<String, NodeSample> performAggregations() {
        return this.performAggregations(System.currentTimeMillis());
    }

    public synchronized Map<String, NodeSample> performAggregations(long timestamp) {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        }
        ArrayList futures = new ArrayList(this.aggregationsToPerform.size());
        HashMap<String, NodeSample> resultSamples = new HashMap<String, NodeSample>();
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Timestamp must be a positive value");
        }
        this.metricSampleCounts.clear();
        this.nSamplesReceived = 0;
        if (this.samples.isEmpty()) {
            logger.warn("No samples to aggregate, returning empty result");
            return resultSamples;
        }
        List<AggregationResult> results = Collections.synchronizedList(new LinkedList());
        for (Aggregation aggregation : this.aggregationsToPerform) {
            futures.add(this.executor.submit(() -> {
                AggregationInput ai = new AggregationInput();
                AggregationResult ar = new AggregationResult(timestamp, this.protocolIdsToNames);
                for (MetricIdentifier mi : aggregation.getMetricIdentifiers()) {
                    Map metricSamples = this.samples.getOrDefault(mi, new HashMap());
                    if (metricSamples.isEmpty()) {
                        logger.warn("Aggregation {} - metric {} was not present in the samples", (Object)aggregation.getClass().getName(), (Object)mi);
                    }
                    if (metricSamples.size() == 1) {
                        logger.warn("Aggregation {} - metric {} was only present for one host", (Object)aggregation.getClass().getName(), (Object)mi);
                    }
                    this.metricSampleCounts.putIfAbsent(mi, metricSamples.size());
                    for (Map.Entry entry : metricSamples.entrySet()) {
                        ai.addMetricSample((String)entry.getKey(), mi, (MetricSample)entry.getValue());
                    }
                }
                AggregationResult result = aggregation.aggregate(ai, ar);
                if (result != null) {
                    results.add(result);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Aggregation task failed", (Throwable)e);
            }
        }
        if (this.retainUnaggregatedMetrics) {
            AggregationResult ar = new AggregationResult(timestamp, this.protocolIdsToNames);
            for (MetricIdentifier mi : this.metricsNotAggregated) {
                for (Map.Entry<String, MetricSample> entry : this.samples.get(mi).entrySet()) {
                    ar.addSample(entry.getValue(), mi.getProtocolId(), entry.getKey());
                }
            }
            results.add(ar);
        }
        for (AggregationResult aggregationResult : results) {
            for (Map.Entry<HostProtocolIdentifier, List<MetricSample>> entry : aggregationResult.getAggregatedSamples().entrySet()) {
                if (!resultSamples.containsKey(entry.getKey().getHost())) {
                    resultSamples.put(entry.getKey().getHost(), new NodeSample());
                }
                short protoID = entry.getKey().getProtocolId();
                if (!((NodeSample)resultSamples.get(entry.getKey().getHost())).getProtocols().contains(protoID)) {
                    ProtocolSample es = new ProtocolSample(protoID, this.protocolIdsToNames.get(protoID), entry.getValue());
                    ((NodeSample)resultSamples.get(entry.getKey().getHost())).addProtocolSample(protoID, es);
                    continue;
                }
                for (MetricSample metricSample : entry.getValue()) {
                    ((NodeSample)resultSamples.get(entry.getKey().getHost())).getProtocolSample(protoID).addMetricSample(metricSample);
                }
            }
        }
        this.samples.clear();
        return resultSamples;
    }
}

