/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.messages.SendMetricsMessage;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Monitor;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.Storage;
import pt.unl.fct.di.novasys.babel.metrics.monitor.timers.AggregationTimer;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class SimpleMonitor
extends Monitor {
    public static final String PROTOCOL_NAME = "MetricsMonitor";
    public static final short PROTOCOL_ID = 6666;
    private int channelId;
    private Storage metricStorage;
    private long aggregationTimer;
    private Host myself;
    private final Logger logger = LogManager.getLogger(SimpleMonitor.class);

    public SimpleMonitor(Host myself, Storage metricStorage) {
        super(PROTOCOL_NAME, (short)6666);
        this.myself = myself;
        this.metricStorage = metricStorage;
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.aggregationTimer = Long.parseLong(props.getProperty("Monitor.aggregationTimer", "12000"));
        Properties channelProperties = new Properties();
        channelProperties.setProperty("address", this.myself.getAddress().getHostAddress());
        channelProperties.setProperty("port", "" + this.myself.getPort());
        this.channelId = this.createChannel("TCPChannel", channelProperties);
        this.registerMessageSerializer(this.channelId, (short)2929, SendMetricsMessage.serializer);
        this.registerMessageHandler(this.channelId, (short)2929, this::uponReceiveSendMetricsMessage);
        this.registerTimerHandler((short)11101, this::uponAggregationTimer);
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
        this.setupPeriodicTimer(new AggregationTimer(), this.aggregationTimer, this.aggregationTimer);
    }

    private void uponAggregationTimer(AggregationTimer timer, long timerId) {
        try {
            this.logger.info("Aggregating from {} nodes", (Object)this.getAggregationManager().numberOfHostsIncludedNextAggregation());
            for (MetricIdentifier mid : this.getAggregationManager().getMetricsBelongingToAggregation()) {
                int count = this.getAggregationManager().getMetricSampleCount(mid.getProtocolId(), mid.getMetricName());
                this.logger.debug("Metric {} from protocol {} has {} samples", (Object)mid.getMetricName(), (Object)mid.getProtocolId(), (Object)count);
            }
            Map<String, NodeSample> result = this.performAggregations();
            if (result.isEmpty()) {
                this.logger.info("No samples aggregated!");
                return;
            }
            this.metricStorage.store(result);
        }
        catch (Exception e) {
            this.logger.error(e);
            e.printStackTrace();
        }
    }

    private void uponReceiveSendMetricsMessage(SendMetricsMessage msg, Host from, short sourceProto, int channelId) {
        NodeSample sample = msg.getSample();
        this.addSampleToAggregate(from.toString(), sample);
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        this.logger.trace("Host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        this.logger.trace("Connection to host {} failed, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        this.logger.trace("Host (out) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        this.logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        this.logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }
}

