/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.monitor.aggregation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.StatsGauge;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationInput;
import pt.unl.fct.di.novasys.babel.metrics.monitor.AggregationResult;
import pt.unl.fct.di.novasys.babel.metrics.monitor.MetricIdentifier;

public class DefaultAggregation
extends Aggregation {
    private static final String DELIMITER = ";";
    String globalID = "";

    public DefaultAggregation(short protocolId, String metricName) {
        super(protocolId, metricName);
    }

    public DefaultAggregation(short protocolId, String metricName, String globalID) {
        super(protocolId, metricName);
        this.globalID = globalID;
    }

    private Map<String, Double> aggregateCounter(Iterator<MetricSample> samples) {
        HashMap<String, Double> resultSamples = new HashMap<String, Double>();
        while (samples.hasNext()) {
            MetricSample sample = samples.next();
            for (int i = 0; i < sample.getSamples().length; ++i) {
                String labelValuesWithPlusSeparator = String.join((CharSequence)DELIMITER, sample.getSamples()[i].getLabelsValues());
                double value = 0.0;
                if (resultSamples.containsKey(labelValuesWithPlusSeparator)) {
                    value = (Double)resultSamples.get(labelValuesWithPlusSeparator);
                }
                resultSamples.put(labelValuesWithPlusSeparator, value + sample.getSamples()[i].getValue());
            }
        }
        return resultSamples;
    }

    private Map<String, Double> aggregateGauge(Iterator<MetricSample> samples, int nHosts) {
        Map<String, Double> resultSamples = this.aggregateCounter(samples);
        for (Map.Entry<String, Double> entry : resultSamples.entrySet()) {
            entry.setValue(entry.getValue() / (double)nHosts);
        }
        return resultSamples;
    }

    private Map<String, Double> aggregateStatsGauge(Iterator<MetricSample> samples) {
        HashMap<String, Double> resultSamples = new HashMap<String, Double>();
        double accCount = 0.0;
        double accCountTimesAvg = 0.0;
        double finalMin = Double.MAX_VALUE;
        double finalmax = Double.MIN_VALUE;
        HashSet<StatsGauge.StatType> aggregatedStats = new HashSet<StatsGauge.StatType>();
        while (samples.hasNext()) {
            MetricSample sample = samples.next();
            double thisCount = 0.0;
            double thisAvg = 0.0;
            block19: for (int i = 0; i < sample.getSamples().length; ++i) {
                String stat = sample.getSamples()[i].getLabelsValues()[0];
                double value = sample.getSamples()[i].getValue();
                switch (stat) {
                    case "count": {
                        accCount += value;
                        thisCount = value;
                        aggregatedStats.add(StatsGauge.StatType.COUNT);
                        continue block19;
                    }
                    case "avg": {
                        thisAvg = value;
                        aggregatedStats.add(StatsGauge.StatType.AVG);
                        continue block19;
                    }
                    case "min": {
                        finalMin = Math.min(value, finalMin);
                        aggregatedStats.add(StatsGauge.StatType.MIN);
                        continue block19;
                    }
                    case "max": {
                        finalmax = Math.max(value, finalmax);
                        aggregatedStats.add(StatsGauge.StatType.MAX);
                        continue block19;
                    }
                }
            }
            accCountTimesAvg += thisCount * thisAvg;
        }
        for (StatsGauge.StatType statType : aggregatedStats) {
            switch (statType) {
                case COUNT: {
                    resultSamples.put("count", accCount);
                    break;
                }
                case AVG: {
                    if (accCount == 0.0) break;
                    resultSamples.put("avg", accCountTimesAvg / accCount);
                    break;
                }
                case MIN: {
                    resultSamples.put("min", finalMin);
                    break;
                }
                case MAX: {
                    resultSamples.put("max", finalmax);
                    break;
                }
            }
        }
        return resultSamples;
    }

    private Map<String, Double> aggregateHistogram(Iterator<MetricSample> samples) {
        return this.aggregateCounter(samples);
    }

    private Map<String, Double> aggregateRecord(Iterator<MetricSample> samples) {
        return this.aggregateCounter(samples);
    }

    @Override
    public AggregationResult aggregate(AggregationInput aggregationInput, AggregationResult aggregationResult) {
        if (aggregationInput.getMetrics().size() != 1) {
            throw new IllegalArgumentException("DefaultAggregation can only aggregate one metric");
        }
        MetricIdentifier mid = aggregationInput.getMetrics().getFirst();
        List<MetricSample> metricSampleMap = aggregationInput.getSamples(mid.getProtocolId(), mid.getMetricName());
        if (metricSampleMap.isEmpty()) {
            return aggregationResult;
        }
        int nHosts = metricSampleMap.size();
        MetricSample sample = metricSampleMap.getFirst();
        String[] labelNames = sample.getLabelNames();
        Iterator<MetricSample> it = metricSampleMap.iterator();
        Map<String, Double> resultingSamples = switch (sample.getMetricType().toString()) {
            case "counter" -> this.aggregateCounter(it);
            case "gauge" -> this.aggregateGauge(it, nHosts);
            case "histogram" -> this.aggregateHistogram(it);
            case "record" -> this.aggregateRecord(it);
            case "statsgauge" -> this.aggregateStatsGauge(it);
            default -> throw new IllegalArgumentException("Unknown metric type");
        };
        Sample[] samplesArray = new Sample[resultingSamples.size()];
        int i = 0;
        for (Map.Entry<String, Double> entry : resultingSamples.entrySet()) {
            String[] labels = entry.getKey().split(DELIMITER);
            samplesArray[i] = new Sample(entry.getValue(), labelNames, labels);
            ++i;
        }
        MetricSample resultingMetricSample = sample.hasLabels() ? MetricSample.builder(sample.getMetricUnit(), sample.getMetricName(), sample.getMetricType()).labelNames(labelNames).build(samplesArray) : MetricSample.builder(sample.getMetricUnit(), sample.getMetricName(), sample.getMetricType()).build(samplesArray[0]);
        if (!this.globalID.isEmpty()) {
            aggregationResult.addSample(resultingMetricSample, mid.getProtocolId(), this.globalID);
        } else {
            aggregationResult.addGlobalSample(resultingMetricSample, mid.getProtocolId());
        }
        return aggregationResult;
    }
}

