/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.discovery;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.notifications.MicroBabelIdentityInformation;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request.MicroBabelDiscoveryRegister;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request.MicroBabelExternalMessage;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.timers.DiscoveryAnnounceTimer;

public class MicroBabelDiscoveryProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "MicroBabelDiscovery";
    public static final short PROTOCOL_ID = 31001;
    public static final String PAR_MULTICAST_ADDRESS = "Babel.Micro.Discovery.MulticastAddress";
    public static final String DEFAULT_MULTICAST_ADDRESS = "239.255.255.250";
    public static final String PAR_MULTICAST_PORT = "Babel.Micro.Discovery.MulticastPort";
    public static final short DEFAULT_MULTICAST_PORT = 9100;
    public static final String PAR_UNICAST_PORT = "Babel.Micro.Discovery.UnicastPort";
    public static final short DEFAULT_UNICAST_PORT = 8888;
    public static final String PAR_MULTICAST_PERIOD = "Babel.Micro.Discovery.Announce.Period";
    public static final long DEFAULT_MULTICAST_PERIOD = 10000L;
    private static final Logger logger = LogManager.getLogger(MicroBabelDiscoveryProtocol.class);
    public static final short HANDSHAKE_MESSAGE_ID = 0;
    private String multicast_address;
    private short multicast_port;
    private short unicast_port;
    private long announce_period;
    private UUID myUniqueIdentifier;
    private MulticastSocket socket;
    private ServerSocket serverSocket;
    private byte[] message;
    private Thread listenSocketThread;
    private final HashMap<Short, String> registeredProtocols;
    private final ConcurrentHashMap<UUID, Socket> clientSockets;
    private final ConcurrentHashMap<UUID, LinkedBlockingQueue<MicroBabelExternalMessage>> clientMessageQueues;

    public MicroBabelDiscoveryProtocol() {
        this(UUID.randomUUID());
    }

    public MicroBabelDiscoveryProtocol(UUID myID) {
        super(PROTOCOL_NAME, (short)31001);
        this.myUniqueIdentifier = myID;
        this.registeredProtocols = new HashMap();
        this.clientSockets = new ConcurrentHashMap();
        this.clientMessageQueues = new ConcurrentHashMap();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.multicast_address = props.containsKey(PAR_MULTICAST_ADDRESS) ? props.getProperty(PAR_MULTICAST_ADDRESS) : DEFAULT_MULTICAST_ADDRESS;
        this.multicast_port = props.containsKey(PAR_MULTICAST_PORT) ? Short.parseShort(props.getProperty(PAR_MULTICAST_PORT)) : (short)9100;
        this.unicast_port = props.containsKey(PAR_UNICAST_PORT) ? Short.parseShort(props.getProperty(PAR_UNICAST_PORT)) : (short)8888;
        this.announce_period = props.containsKey(PAR_MULTICAST_PERIOD) ? Long.parseLong(props.getProperty(PAR_MULTICAST_PERIOD)) : 10000L;
        this.socket = new MulticastSocket(this.unicast_port);
        HashSet<InetAddress> myAddresses = new HashSet<InetAddress>();
        if (props.containsKey("babel.interface")) {
            NetworkInterface iface = NetworkInterface.getByName(props.getProperty("babel.interface"));
            if (iface != null) {
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    myAddresses.add(address);
                }
                logger.info("Joing multicast group with interface: " + iface.getDisplayName() + " :: " + iface.toString());
                this.socket.joinGroup(new InetSocketAddress(this.multicast_address, (int)this.multicast_port), iface);
            } else {
                logger.info("Could not find interface with name: " + props.getProperty("babel.interface"));
            }
        } else {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                boolean found = false;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    found = true;
                    myAddresses.add(address);
                }
                if (!found || !iface.supportsMulticast()) continue;
                logger.info("Joing multicast group with interface: " + iface.getDisplayName() + " :: " + iface.toString());
                this.socket.joinGroup(new InetSocketAddress(this.multicast_address, (int)this.multicast_port), iface);
            }
        }
        if (myAddresses.size() <= 0) {
            logger.error("No valid address was found.");
            return;
        }
        logger.info("My current ip addresses to be announced:");
        for (InetAddress addr : myAddresses) {
            logger.info(addr.toString());
        }
        this.serverSocket = new ServerSocket(this.unicast_port);
        this.listenSocketThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MicroBabelDiscoveryProtocol.this.acceptIncommingConnections();
            }
        });
        this.listenSocketThread.start();
        this.message = new byte[22 + 4 * myAddresses.size() + 2 + 8];
        ByteBuffer bb = ByteBuffer.wrap(this.message).order(ByteOrder.BIG_ENDIAN);
        bb.put((byte)109).put((byte)98).put((byte)109).put((byte)97);
        bb.putLong(this.myUniqueIdentifier.getMostSignificantBits()).putLong(this.myUniqueIdentifier.getLeastSignificantBits());
        short na = (short)myAddresses.size();
        bb.putShort(na);
        for (InetAddress addr : myAddresses) {
            byte[] ipv4addr = addr.getAddress();
            logger.info("Adding to message: " + String.valueOf(addr) + " with " + ipv4addr.length + " bytes");
            bb.put(ipv4addr);
        }
        bb.putShort(this.unicast_port);
        bb.putLong(this.announce_period);
        this.registerTimerHandler((short)31001, this::handleDiscoveryAnnounceTimer);
        this.registerRequestHandler((short)31000, this::handleMicroBabelDiscoveryRegister);
        this.registerRequestHandler((short)31002, this::handleMicroBabelExternalMessage);
        this.setupPeriodicTimer(new DiscoveryAnnounceTimer(), 10L, this.announce_period);
        this.triggerNotification(new MicroBabelIdentityInformation(this.myUniqueIdentifier));
    }

    private void handleDiscoveryAnnounceTimer(DiscoveryAnnounceTimer timer, long time) {
        logger.info("Multicast timer.");
        try {
            DatagramPacket dp = new DatagramPacket(this.message, this.message.length, InetAddress.getByName(this.multicast_address), this.multicast_port & 0xFFFF);
            this.socket.send(dp);
            logger.info("Issed multicast announcemente for node " + this.myUniqueIdentifier.toString() + ".");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleMicroBabelDiscoveryRegister(MicroBabelDiscoveryRegister request, short protoId) {
        this.registeredProtocols.put(request.getProtoID(), request.getProtocolName());
    }

    private void handleMicroBabelExternalMessage(MicroBabelExternalMessage request, short protoId) {
        BlockingQueue queue = this.clientMessageQueues.get(request.getDestNode());
        try {
            if (queue == null) {
                throw new Exception("Got request to transmit to " + String.valueOf(request.getDestNode()) + " but could not find a queue");
            }
            logger.info("Put a message to be sent on the queue of " + String.valueOf(request.getDestNode()));
            queue.put(request);
        }
        catch (Exception e) {
            logger.error("Unable to push external message to a queue.");
            e.printStackTrace();
        }
    }

    private void acceptIncommingConnections() {
        while (true) {
            try {
                while (true) {
                    final Socket microBabelClient = this.serverSocket.accept();
                    Thread client = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MicroBabelDiscoveryProtocol.this.handleMicroBabelClient(microBabelClient);
                        }
                    });
                    client.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    private void handleMicroBabelClient(Socket microBabelClient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handlingSendingOfMessagesForClient(OutputStream out, LinkedBlockingQueue<MicroBabelExternalMessage> queue) {
        byte[] msgLength = new byte[2];
        ByteBuffer bb = ByteBuffer.wrap(msgLength).order(ByteOrder.BIG_ENDIAN);
        logger.info("Initializing send thread with a client...");
        try {
            while (true) {
                MicroBabelExternalMessage msg;
                if ((msg = queue.take()).getMessageType() == 666) {
                    return;
                }
                bb.rewind();
                bb.putShort(msg.getTotalSize());
                out.write(msgLength);
                out.write(MicroBabelExternalMessage.serialize(msg));
                out.flush();
                logger.info("Sent a message to one of the clients");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

