/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;

public class MicroBabelExternalMessage
extends ProtoRequest {
    public static final short REQUEST_ID = 31002;
    public static final short MESSAGE_FIN_CODE = 666;
    private final short messageType;
    private final UUID sourceNode;
    private final short sourceProto;
    private final UUID destNode;
    private final short destProto;
    private final short payloadLenght;
    private final byte[] payload;

    public MicroBabelExternalMessage(short msgType, UUID src, short srcProto, UUID dst, short dstProto, short paylen, byte[] pay) {
        super((short)31002);
        this.messageType = msgType;
        this.sourceNode = src;
        this.sourceProto = srcProto;
        this.destNode = dst;
        this.destProto = dstProto;
        this.payloadLenght = paylen;
        this.payload = pay;
    }

    public static byte[] serialize(MicroBabelExternalMessage msg) {
        byte[] buffer = new byte[msg.getTotalSize()];
        ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.BIG_ENDIAN);
        buf.putShort(msg.messageType);
        buf.putLong(msg.sourceNode.getMostSignificantBits());
        buf.putLong(msg.sourceNode.getLeastSignificantBits());
        buf.putShort(msg.sourceProto);
        buf.putLong(msg.destNode.getMostSignificantBits());
        buf.putLong(msg.destNode.getLeastSignificantBits());
        buf.putShort(msg.destProto);
        buf.putShort(msg.payloadLenght);
        if (msg.payload != null && msg.payloadLenght > 0) {
            buf.put(msg.payload);
        }
        return buffer;
    }

    public short getMessageType() {
        return this.messageType;
    }

    public UUID getSourceNode() {
        return this.sourceNode;
    }

    public short getSourceProto() {
        return this.sourceProto;
    }

    public UUID getDestNode() {
        return this.destNode;
    }

    public short getDestProto() {
        return this.destProto;
    }

    public short getPayloadLenght() {
        return this.payloadLenght;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short getTotalSize() {
        return (short)(this.payloadLenght + 8 + 32);
    }

    public static MicroBabelExternalMessage generateFin() {
        return new MicroBabelExternalMessage(666, null, 0, null, 0, 0, null);
    }
}

