/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;

public class MicroBabelExternalRequest
extends ProtoRequest {
    public static final short REQUEST_ID = 31001;
    private final short messageType;
    private final UUID sourceNode;
    private final short sourceProto;
    private final UUID destNode;
    private final short destProto;
    private final short payloadLenght;
    private final byte[] payload;

    public MicroBabelExternalRequest(short msgType, UUID src, short srcProto, UUID dst, short dstProto, short paylen, byte[] pay) {
        super((short)31001);
        this.messageType = msgType;
        this.sourceNode = src;
        this.sourceProto = srcProto;
        this.destNode = dst;
        this.destProto = dstProto;
        this.payloadLenght = paylen;
        this.payload = pay;
    }

    public static MicroBabelExternalRequest readFromStream(InputStream in, short requestLength) throws IOException {
        byte[] msg = new byte[requestLength];
        int target = requestLength;
        for (int read = 0; read < requestLength; read += in.read(msg, read, target - read)) {
        }
        ByteBuffer bb = ByteBuffer.wrap(msg).order(ByteOrder.BIG_ENDIAN);
        short messageType = bb.getShort();
        long msb = bb.getLong();
        long lsb = bb.getLong();
        UUID nodeSender = new UUID(msb, lsb);
        short sourceProto = bb.getShort();
        msb = bb.getLong();
        lsb = bb.getLong();
        UUID nodeDest = new UUID(msb, lsb);
        short destProto = bb.getShort();
        short payloadSize = bb.getShort();
        byte[] payload = null;
        if (payloadSize > 0) {
            payload = new byte[payloadSize];
            bb.get(payload);
        }
        return new MicroBabelExternalRequest(messageType, nodeSender, sourceProto, nodeDest, destProto, payloadSize, payload);
    }

    public short getMessageType() {
        return this.messageType;
    }

    public UUID getSourceNode() {
        return this.sourceNode;
    }

    public short getSourceProto() {
        return this.sourceProto;
    }

    public UUID getDestNode() {
        return this.destNode;
    }

    public short getDestProto() {
        return this.destProto;
    }

    public short getPayloadLenght() {
        return this.payloadLenght;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String toString() {
        return "External Message -> [msgType: " + this.messageType + " src: " + String.valueOf(this.sourceNode) + ":" + this.sourceProto + " dest: " + String.valueOf(this.destNode) + ":" + this.destProto + " payload size: " + this.payloadLenght + "]";
    }
}

