/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.notifications.MicroBabelDisconnectedProbe;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.notifications.MicroBabelIdentityInformation;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request.MicroBabelDiscoveryRegister;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request.MicroBabelExternalMessage;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.request.MicroBabelExternalRequest;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data.CellPhoneCommand;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data.MassDeviceOperation;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data.RegisteredDevices;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data.RequestAnnouncement;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.requests.ExportIoTDeviceRequest;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.requests.UnexportIoTDeviceRequest;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.timers.AnnounceDevicesTimer;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.timers.BlinkTimer;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.requests.BroadcastRequest;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLedMatrix;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ClearDisplayRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetDisplayColorRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetMultipleChainableLEDColorRGBRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowDisplayRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowTextRequest;

public class IoTRemoteControlProtocol
extends GenericProtocol {
    public static final short UNICAST_OP = 0;
    public static final short BROADCAST_OP = 1;
    public static final short DEVICE_TYPE_LED_RGB = 1;
    public static final short DEVICE_TYPE_LED_MATRIX = 2;
    public static final short DEVICE_TYPE_LCD_DISPLAY = 3;
    public static final short DEVICE_ACTION_ON = 1;
    public static final short DEVICE_ACTION_BLINK = 2;
    public static final short DEVICE_ACTION_OFF = 3;
    public static final short DEVICE_ACTION_SHOW_EMOJI = 4;
    public static final short DEVICE_ACTION_CLEAR = 5;
    public static final short DEVICE_ACTION_SHOW_ANIMATION = 6;
    public static final short DEVICE_ACTION_SET_COLOR = 7;
    public static final short DEVICE_ACTION_SHOW_TEXT = 8;
    public static final short DEVICE_ACTION_SET_LETTER = 9;
    public static final short DEVICE_ACTION_SET_SYMBOL = 10;
    public static final short DEVICE_ACTION_SET_MATRIX = 11;
    public static final short DEVICE_PARAM_COLOR_RED = 1;
    public static final short DEVICE_PARAM_COLOR_GREEN = 2;
    public static final short DEVICE_PARAM_COLOR_BLUE = 3;
    public static final short DEVICE_PARAM_COLOR_WHITE = 4;
    public static final short DEVICE_PARAM_COLOR_ORANGE = 5;
    public static final short DEVICE_PARAM_COLOR_YELLOW = 6;
    public static final short DEVICE_PARAM_COLOR_CYAN = 7;
    public static final short DEVICE_PARAM_COLOR_PURPLE = 8;
    public static final short DEVICE_PARAM_COLOR_PINK = 9;
    public static final short DEVICE_PARAM_COLOR_BLACK = 10;
    public static final short MSG_INIT = 17001;
    public static final short MSG_CMD = 17002;
    public static final short MSG_DEVICE_UPDATE = 17003;
    public static final short DEVICE_PARAM_TEXT_HELLO = 1;
    public static final short DEVICE_PARAM_TEXT_YES = 2;
    public static final short DEVICE_PARAM_TEXT_NO = 3;
    public static final short PROTOCOL_ID = 17000;
    public static final String PROTOCOL_NAME = "IotRemoveControlProtocol";
    public static final String PAR_BCAST_PROTO = "iot.remote.control.bcast";
    public static final short DEFAULT_BCAST_PROTO = 1600;
    public static final String PAR_IOT_CONTROL_PROTO = "iot.remote.control.iotcontrol";
    public static final short DEFAULT_IOT_CONTROL_PROTO = 4000;
    public static final long BLINK_PERIOD = 1000L;
    private final HashMap<Short, DeviceHandle> localDeviceHandles;
    private final HashMap<UUID, Set<Short>> remoteDevices;
    private final HashMap<Host, Set<Short>> remoteDevicesByHost;
    private final HashSet<UUID> connectedProbes;
    private final Host hostID;
    private UUID localNodeID;
    private short bcastProtoId;
    private static final Logger logger = LogManager.getLogger(IoTRemoteControlProtocol.class);
    private Long blinkerTimerID;
    private Long announceTimerID;
    private final Map<Short, byte[]> colors;

    public IoTRemoteControlProtocol(Host hostID) {
        super(PROTOCOL_NAME, (short)17000);
        this.hostID = hostID;
        this.localDeviceHandles = new HashMap();
        this.remoteDevices = new HashMap();
        this.remoteDevicesByHost = new HashMap();
        this.connectedProbes = new HashSet();
        this.localNodeID = null;
        this.blinkerTimerID = null;
        this.announceTimerID = null;
        this.colors = new HashMap<Short, byte[]>();
        this.colors.put((short)1, new byte[]{-1, 0, 0});
        this.colors.put((short)2, new byte[]{0, -128, 0});
        this.colors.put((short)3, new byte[]{0, 0, -1});
        this.colors.put((short)4, new byte[]{-1, -1, -1});
        this.colors.put((short)5, new byte[]{-1, -91, 0});
        this.colors.put((short)6, new byte[]{-1, -1, 0});
        this.colors.put((short)7, new byte[]{0, -1, -1});
        this.colors.put((short)8, new byte[]{-128, 0, -128});
        this.colors.put((short)9, new byte[]{-1, 105, -1});
        this.colors.put((short)10, new byte[]{0, 0, 0});
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.bcastProtoId = props.containsKey(PAR_BCAST_PROTO) ? Short.parseShort(props.getProperty(PAR_BCAST_PROTO)) : (short)1600;
        this.registerRequestHandler((short)17001, this::handleExportIoTDeviceRequest);
        this.registerRequestHandler((short)17002, this::handleUnexportIoTDeviceRequest);
        this.registerRequestHandler((short)31001, this::handleMicroBabelExternalRequest);
        this.subscribeNotification((short)31001, this::handleMicroBabelIdentityInformationNotification);
        this.subscribeNotification((short)501, this::handleBroadcastMessage);
        this.subscribeNotification((short)31002, this::handleMicroBabelDisconnectedProbeNotification);
        this.registerTimerHandler((short)17001, this::uponBlinkTimer);
        this.sendRequest(new MicroBabelDiscoveryRegister(17000, PROTOCOL_NAME), (short)31001);
        this.registerTimerHandler((short)17002, this::handleAnnounceDevicesTimer);
    }

    private void handleMicroBabelDisconnectedProbeNotification(MicroBabelDisconnectedProbe not, short ProtoId) {
        this.connectedProbes.remove(not.getProbeID());
    }

    private void handleAnnounceDevicesTimer(AnnounceDevicesTimer t2, long time) {
        logger.info("Received AnnounceDevicesTimer");
        if (this.announceTimerID != null) {
            RegisteredDevices rd = new RegisteredDevices(this.localNodeID, this.localDeviceHandles.keySet());
            try {
                BroadcastRequest br = new BroadcastRequest(this.hostID, rd.toByteArray(), 17000);
                this.sendRequest(br, this.bcastProtoId);
                if (t2 != null) {
                    logger.info("Made the periodic announcement of my devices for a total of " + rd.getDevices().size() + " devices.");
                } else {
                    logger.info("Made an announcement of my devices for a totoal of " + rd.getDevices().size() + " by explicit request");
                }
            }
            catch (Exception e) {
                logger.error("Could not send a broadcast request updating my devices", (Throwable)e);
            }
        }
    }

    private void handleExportIoTDeviceRequest(ExportIoTDeviceRequest request, short protoSource) {
        if (!this.localDeviceHandles.containsKey(request.getDeviceTypeID())) {
            this.localDeviceHandles.put(request.getDeviceTypeID(), request.getDeviceHandle());
            if (this.localNodeID != null) {
                RegisteredDevices rd = new RegisteredDevices(this.localNodeID, this.localDeviceHandles.keySet());
                try {
                    BroadcastRequest br = new BroadcastRequest(this.hostID, rd.toByteArray(), 17000);
                    this.sendRequest(br, this.bcastProtoId);
                    byte[] updPayload = rd.serializeToMessage();
                    for (UUID destNodeID : this.connectedProbes) {
                        MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, destNodeID, 17000, (short)updPayload.length, updPayload);
                        this.sendRequest(upd, (short)31001);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not send a broadcast request updating my devices", (Throwable)e);
                }
            }
        }
        if (this.localDeviceHandles.keySet().size() > 0 && this.announceTimerID == null) {
            this.announceTimerID = this.setupPeriodicTimer(new AnnounceDevicesTimer(), 30000L, 30000L);
        } else if (this.localDeviceHandles.keySet().size() == 0 && this.announceTimerID != null) {
            this.cancelTimer(this.announceTimerID);
            this.announceTimerID = null;
        }
    }

    private void handleUnexportIoTDeviceRequest(UnexportIoTDeviceRequest request, short protoSource) {
        if (this.localDeviceHandles.containsKey(request.getDeviceTypeID())) {
            this.localDeviceHandles.remove(request.getDeviceTypeID());
            if (this.localNodeID != null) {
                RegisteredDevices rd = new RegisteredDevices(this.localNodeID, this.localDeviceHandles.keySet());
                try {
                    BroadcastRequest br = new BroadcastRequest(this.hostID, rd.toByteArray(), 17000);
                    this.sendRequest(br, this.bcastProtoId);
                    byte[] updPayload = rd.serializeToMessage();
                    for (UUID destNodeID : this.connectedProbes) {
                        MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, destNodeID, 17000, (short)updPayload.length, updPayload);
                        this.sendRequest(upd, (short)31001);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not send a broadcast request updating my devices", (Throwable)e);
                }
            }
        }
        if (this.localDeviceHandles.keySet().size() > 0 && this.announceTimerID == null) {
            this.announceTimerID = this.setupPeriodicTimer(new AnnounceDevicesTimer(), 30000L, 30000L);
        } else if (this.localDeviceHandles.keySet().size() == 0 && this.announceTimerID != null) {
            this.cancelTimer(this.announceTimerID);
            this.announceTimerID = null;
        }
    }

    private void handleBroadcastMessage(BroadcastDelivery bcastMessage, short protoSource) {
        logger.info("Received a broadcast message.");
        try {
            logger.info("GOING TO SEND DEVICE ANNOUNCMENTS BY REQUEST.");
            if (RequestAnnouncement.fromByteArray(bcastMessage.getPayload()) != null) {
                this.handleAnnounceDevicesTimer(null, protoSource);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RegisteredDevices rd = RegisteredDevices.fromByteArray(bcastMessage.getPayload());
            if (rd != null) {
                logger.info("Received a braodcast message from sourceID: " + rd.getNodeID().toString() + " (my id is: " + this.localNodeID.toString() + ")");
                if (rd.getNodeID().equals(this.localNodeID)) {
                    return;
                }
                this.remoteDevicesByHost.remove(bcastMessage.getSender());
                this.remoteDevices.remove(rd.getNodeID());
                Set<Short> devs = rd.getDevices();
                if (devs.size() > 0) {
                    this.remoteDevices.put(rd.getNodeID(), devs);
                    this.remoteDevicesByHost.put(bcastMessage.getSender(), devs);
                }
                if (this.localNodeID != null) {
                    byte[] updPayload = rd.serializeToMessage();
                    for (UUID destNodeID : this.connectedProbes) {
                        MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, destNodeID, 17000, (short)updPayload.length, updPayload);
                        this.sendRequest(upd, (short)31001);
                    }
                }
            } else {
                CellPhoneCommand cpc = CellPhoneCommand.fromByteArray(bcastMessage.getPayload());
                MassDeviceOperation mdo = null;
                mdo = cpc == null ? MassDeviceOperation.fromByteArray(bcastMessage.getPayload()) : MassDeviceOperation.fromByteArray(cpc.getCommand());
                if (mdo != null) {
                    logger.info("Received a MassDeviceOperation from sourceID: " + String.valueOf(bcastMessage.getSender()));
                    if (cpc != null && !cpc.getDestinationID().equals(new UUID(0L, 0L)) && !cpc.getDestinationID().equals(this.localNodeID)) {
                        logger.info("The received MassDeviceOperation was not for me, skipping...");
                        return;
                    }
                    if (mdo.getAdditionalArgument() == null) {
                        this.executeIoTDeviceOperation(mdo.getDeviceIdentifier(), mdo.getDeviceAction(), mdo.getDeviceParam());
                    } else {
                        this.executeIoTDeviceOperation(mdo.getDeviceIdentifier(), mdo.getDeviceAction(), mdo.getDeviceParam(), mdo.getAdditionalArgument());
                    }
                } else {
                    logger.debug("Could not retriece a valid MaddDeviceOperation");
                }
            }
        }
        catch (Exception e) {
            logger.debug("Message was not parseable so we are ignorin it: " + e.getMessage());
        }
    }

    private void handleMicroBabelIdentityInformationNotification(MicroBabelIdentityInformation notification, short protoSource) {
        this.localNodeID = notification.getLocalIdentifier();
        logger.info("My local Id has been set, should notify all clients of connected devices...");
        byte[] updPayload = new RegisteredDevices(this.localNodeID, this.localDeviceHandles.keySet()).serializeToMessage();
        for (UUID client : this.connectedProbes) {
            try {
                MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, client, 17000, (short)updPayload.length, updPayload);
                this.sendRequest(upd, (short)31001);
            }
            catch (Exception e) {
                logger.error("Cound not send upd to clint " + String.valueOf(client) + " for record of my own devices (" + String.valueOf(this.localNodeID) + ")");
                e.printStackTrace();
            }
        }
        for (UUID node : this.remoteDevices.keySet()) {
            updPayload = new RegisteredDevices(node, this.remoteDevices.get(node)).serializeToMessage();
            logger.info("Sending information about external node: " + String.valueOf(node));
            for (UUID client : this.connectedProbes) {
                try {
                    MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, client, 17000, (short)updPayload.length, updPayload);
                    this.sendRequest(upd, (short)31001);
                }
                catch (Exception e) {
                    logger.error("Cound not send upd to clint " + String.valueOf(client) + " for record of " + String.valueOf(node));
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleMicroBabelExternalRequest(MicroBabelExternalRequest request, short protoSource) {
        logger.info("Received a MicroBabelExternalRequest from " + String.valueOf(request.getSourceNode()) + "for destination: " + String.valueOf(request.getDestNode()));
        if (request.getDestNode().equals(this.localNodeID) || request.getDestNode().equals(new UUID(0L, 0L))) {
            if (request.getDestNode().equals(this.localNodeID) && request.getMessageType() == 17001) {
                if (this.connectedProbes.add(request.getSourceNode())) {
                    logger.info("Added connected probe: " + String.valueOf(request.getSourceNode()));
                    if (this.localNodeID != null) {
                        byte[] updPayload = new RegisteredDevices(this.localNodeID, this.localDeviceHandles.keySet()).serializeToMessage();
                        try {
                            MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, request.getSourceNode(), 17000, (short)updPayload.length, updPayload);
                            this.sendRequest(upd, (short)31001);
                        }
                        catch (Exception e) {
                            logger.error("Cound not send upd to clint " + String.valueOf(request.getSourceNode()) + " for record of my own devices (" + String.valueOf(this.localNodeID) + ")");
                            e.printStackTrace();
                        }
                        for (UUID node : this.remoteDevices.keySet()) {
                            logger.info("In reaction to an INIT I am sending information about external node: " + String.valueOf(node));
                            updPayload = new RegisteredDevices(node, this.remoteDevices.get(node)).serializeToMessage();
                            try {
                                MicroBabelExternalMessage upd = new MicroBabelExternalMessage(17003, this.localNodeID, 17000, request.getSourceNode(), 17000, (short)updPayload.length, updPayload);
                                this.sendRequest(upd, (short)31001);
                            }
                            catch (Exception e) {
                                logger.error("Cound not send upd to clint " + String.valueOf(request.getSourceNode()) + " for record of " + String.valueOf(node));
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    logger.info("Received duplicated init for connected probe: " + String.valueOf(request.getSourceNode()));
                }
            } else if (request.getMessageType() == 17002) {
                boolean isBroadcastRequest;
                logger.info("Received a MSG_CMD from someone: " + String.valueOf(request.getSourceNode()) + ":" + request.getSourceProto());
                ByteBuffer buf = ByteBuffer.wrap(request.getPayload()).order(ByteOrder.BIG_ENDIAN);
                short deviceIdentifier = buf.getShort();
                short deviceAction = buf.getShort();
                short deviceParam = buf.getShort();
                boolean bl = isBroadcastRequest = buf.getShort() == 1;
                if (isBroadcastRequest) {
                    try {
                        MassDeviceOperation encode = new MassDeviceOperation(deviceIdentifier, deviceAction, deviceParam);
                        BroadcastRequest brequest = new BroadcastRequest(this.hostID, encode.toByteArray(), 17000);
                        logger.info("Sending a broadcasst message with a all device op with codes: " + deviceIdentifier + ":" + deviceAction + ":" + deviceParam);
                        this.sendRequest(brequest, this.bcastProtoId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (!request.getDestNode().equals(this.localNodeID) && !request.getDestNode().equals(new UUID(0L, 0L))) {
                    return;
                }
                this.executeIoTDeviceOperation(deviceIdentifier, deviceAction, deviceParam);
            }
        }
    }

    private void uponBlinkTimer(BlinkTimer t2, long timerId) {
        if (this.blinkerTimerID == null || this.blinkerTimerID != timerId) {
            return;
        }
        DeviceHandle h2 = this.localDeviceHandles.get((short)1);
        if (h2 != null) {
            short deviceParam = t2.getParam();
            SetMultipleChainableLEDColorRGBRequest ledReq = null;
            if (t2.flipAndGetTurnOn()) {
                ledReq = new SetMultipleChainableLEDColorRGBRequest(h2);
                byte[] colorsBytes = this.colors.get(deviceParam);
                if (colorsBytes == null) {
                    colorsBytes = new byte[]{-1, -1, -1};
                }
                ledReq.setValuesForPosition((byte)0, colorsBytes[0], colorsBytes[1], colorsBytes[2]);
            } else {
                ledReq = new SetMultipleChainableLEDColorRGBRequest(h2);
                ledReq.setValuesForPosition((byte)0, (byte)0, (byte)0, (byte)0);
            }
            this.blinkerTimerID = this.setupTimer(t2, 1000L);
            if (ledReq != null) {
                this.sendRequest(ledReq, (short)4003);
            }
        }
    }

    private void executeIoTDeviceOperation(short deviceIdentifier, short deviceAction, short deviceParam, byte[] extraParam) {
        logger.info("I am trying to execute a command with paramters -> device: " + deviceIdentifier + " action: " + deviceAction + " param: " + deviceParam + " and an addtitional byte[] argument (with " + extraParam.length + " bytes");
        DeviceHandle h2 = this.localDeviceHandles.get(deviceIdentifier);
        if (h2 != null) {
            block1 : switch (deviceIdentifier) {
                case 2: {
                    logger.debug("DEVICE_TYPE_LED_MATRIX");
                    switch (deviceAction) {
                        case 11: {
                            byte[] display = new byte[64];
                            try {
                                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(extraParam));
                                block23: for (int i = 0; i < 64; ++i) {
                                    switch (dis.readInt()) {
                                        case 1: {
                                            display[i] = 0;
                                            continue block23;
                                        }
                                        case 2: {
                                            display[i] = 82;
                                            continue block23;
                                        }
                                        case 3: {
                                            display[i] = -86;
                                            continue block23;
                                        }
                                        case 4: {
                                            display[i] = -2;
                                            continue block23;
                                        }
                                        case 5: {
                                            display[i] = 18;
                                            continue block23;
                                        }
                                        case 6: {
                                            display[i] = 24;
                                            continue block23;
                                        }
                                        case 7: {
                                            display[i] = 127;
                                            continue block23;
                                        }
                                        case 8: {
                                            display[i] = -61;
                                            continue block23;
                                        }
                                        case 9: {
                                            display[i] = -36;
                                            continue block23;
                                        }
                                        default: {
                                            display[i] = -1;
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return;
                            }
                            ShowDisplayRequest reqDisp = new ShowDisplayRequest(h2, display);
                            this.sendRequest(reqDisp, (short)4000);
                            break;
                        }
                        default: {
                            logger.debug("Received an enriched argument operation for Led Matrix of unknown type: " + deviceAction);
                        }
                    }
                }
                case 3: {
                    logger.debug("DEVICE_TYPE_LCD_DISPLAY");
                    switch (deviceAction) {
                        case 8: {
                            ShowTextRequest reqST = new ShowTextRequest(h2, new String(extraParam));
                            this.sendRequest(reqST, (short)4000);
                            break block1;
                        }
                    }
                    logger.debug("Received an enriched argument operation for LCD DISPLAY of unknown type: " + deviceAction);
                }
            }
            logger.debug("Received an enriched argument operation for unknown device type: " + deviceIdentifier);
        }
    }

    private void executeIoTDeviceOperation(short deviceIdentifier, short deviceAction, short deviceParam) {
        block36: {
            block35: {
                logger.info("I am trying to execute a command with paramters -> device: " + deviceIdentifier + " action: " + deviceAction + " param: " + deviceParam);
                byte[] colorsBytes = null;
                DeviceHandle h2 = this.localDeviceHandles.get(deviceIdentifier);
                if (h2 == null) break block35;
                switch (deviceIdentifier) {
                    case 1: {
                        logger.debug("DEVICE_TYPE_LED_RGB");
                        SetMultipleChainableLEDColorRGBRequest ledReq = null;
                        switch (deviceAction) {
                            case 1: {
                                if (this.blinkerTimerID != null) {
                                    this.cancelTimer(this.blinkerTimerID);
                                    this.blinkerTimerID = null;
                                }
                                ledReq = new SetMultipleChainableLEDColorRGBRequest(h2);
                                colorsBytes = this.colors.get(deviceParam);
                                if (colorsBytes == null) {
                                    colorsBytes = new byte[]{-1, -1, -1};
                                }
                                ledReq.setValuesForPosition((byte)0, colorsBytes[0], colorsBytes[1], colorsBytes[2]);
                                break;
                            }
                            case 2: {
                                if (this.blinkerTimerID != null) {
                                    this.cancelTimer(this.blinkerTimerID);
                                    this.blinkerTimerID = null;
                                }
                                ledReq = new SetMultipleChainableLEDColorRGBRequest(h2);
                                colorsBytes = this.colors.get(deviceParam);
                                if (colorsBytes == null) {
                                    colorsBytes = new byte[]{-1, -1, -1};
                                }
                                ledReq.setValuesForPosition((byte)0, colorsBytes[0], colorsBytes[1], colorsBytes[2]);
                                this.blinkerTimerID = this.setupTimer(new BlinkTimer(deviceParam), 1000L);
                                break;
                            }
                            case 3: {
                                if (this.blinkerTimerID != null) {
                                    this.cancelTimer(this.blinkerTimerID);
                                    this.blinkerTimerID = null;
                                }
                                ledReq = new SetMultipleChainableLEDColorRGBRequest(h2);
                                ledReq.setValuesForPosition((byte)0, (byte)0, (byte)0, (byte)0);
                                break;
                            }
                            default: {
                                logger.error("LED_RGB device action not supported: " + deviceAction);
                            }
                        }
                        if (ledReq != null) {
                            this.sendRequest(ledReq, (short)4003);
                            break;
                        }
                        break block36;
                    }
                    case 3: {
                        logger.debug("DEVICE_TYPE_LCD_DISPLAY");
                        ShowTextRequest req = null;
                        switch (deviceAction) {
                            case 5: {
                                req = new ShowTextRequest(h2, "");
                                break;
                            }
                            case 8: {
                                String txt = null;
                                switch (deviceParam) {
                                    case 1: {
                                        txt = new String("Hello");
                                        break;
                                    }
                                    case 2: {
                                        txt = new String("Yes!");
                                        break;
                                    }
                                    case 3: {
                                        txt = new String("No!");
                                        break;
                                    }
                                }
                                if (txt == null) break;
                                req = new ShowTextRequest(h2, txt);
                                break;
                            }
                            default: {
                                logger.error("LCD_DISPLAY device action not supported: " + deviceAction);
                            }
                        }
                        if (req != null) {
                            this.sendRequest(req, (short)4000);
                            break;
                        }
                        break block36;
                    }
                    case 2: {
                        logger.debug("DEVICE_TYPE_LED_MATRIX");
                        switch (deviceAction) {
                            case 5: {
                                ClearDisplayRequest reqCls = new ClearDisplayRequest(h2);
                                this.sendRequest(reqCls, (short)4000);
                                break;
                            }
                            case 7: {
                                colorsBytes = this.colors.get(deviceParam);
                                if (colorsBytes == null) {
                                    colorsBytes = new byte[]{-1, -1, -1};
                                }
                                SetDisplayColorRequest reqColor = new SetDisplayColorRequest(h2, colorsBytes[0], colorsBytes[1], colorsBytes[2]);
                                this.sendRequest(reqColor, (short)4000);
                                break;
                            }
                            case 9: {
                                break;
                            }
                            case 10: {
                                break;
                            }
                            case 4: {
                                ShowEmojiRequest reqEmoji = new ShowEmojiRequest(h2, GroveLedMatrix.Emoji.values()[deviceParam]);
                                this.sendRequest(reqEmoji, (short)4000);
                                break;
                            }
                            case 6: {
                                ShowAnimationRequest reqAni = new ShowAnimationRequest(h2, GroveLedMatrix.Animation.values()[deviceParam]);
                                this.sendRequest(reqAni, (short)4000);
                                break;
                            }
                            default: {
                                logger.error("LED_MATRIX device action not supported: " + deviceAction);
                            }
                        }
                    }
                    default: {
                        logger.info("Request for device type " + deviceIdentifier + ": device not supported");
                        break;
                    }
                }
                break block36;
            }
            logger.info("Requests points to handler that is not available: " + deviceIdentifier);
        }
    }
}

