/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data.MassDeviceOperation;

public class CellPhoneCommand {
    private final UUID destinationID;
    private final byte[] command;

    public CellPhoneCommand(UUID destID, byte[] command) {
        this.destinationID = destID;
        this.command = command;
    }

    public CellPhoneCommand(UUID destID, MassDeviceOperation operation) throws Exception {
        this(destID, operation.toByteArray());
    }

    public UUID getDestinationID() {
        return this.destinationID;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeChar(67);
        dos.writeChar(80);
        dos.writeChar(99);
        dos.writeChar(108);
        dos.writeLong(this.destinationID.getMostSignificantBits());
        dos.writeLong(this.destinationID.getLeastSignificantBits());
        dos.writeInt(this.command.length);
        dos.write(this.command);
        return baos.toByteArray();
    }

    public static CellPhoneCommand fromByteArray(byte[] uMsg) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(uMsg);
        DataInputStream dis = new DataInputStream(bais);
        if (dis.readChar() != 'C' || dis.readChar() != 'P' || dis.readChar() != 'c' || dis.readChar() != 'l') {
            return null;
        }
        UUID id = new UUID(dis.readLong(), dis.readLong());
        byte[] cmd = new byte[dis.readInt()];
        dis.read(cmd);
        return new CellPhoneCommand(id, cmd);
    }
}

