/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MassDeviceOperation {
    public static final short OVERRIDE_PARAMETER = 124;
    private final short deviceIdentifier;
    private final short deviceAction;
    private final short deviceParam;
    private byte[] additionalArgument;

    public MassDeviceOperation(short deviceIdentifier, short deviceAction, short deviceParam) {
        this.deviceIdentifier = deviceIdentifier;
        this.deviceAction = deviceAction;
        this.deviceParam = deviceParam;
        this.additionalArgument = null;
    }

    public MassDeviceOperation(short deviceIdentifier, short deviceAction, short deviceParam, byte[] addParam) {
        this.deviceIdentifier = deviceIdentifier;
        this.deviceAction = deviceAction;
        this.deviceParam = deviceParam;
        this.additionalArgument = addParam;
    }

    public short getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public short getDeviceAction() {
        return this.deviceAction;
    }

    public short getDeviceParam() {
        return this.deviceParam;
    }

    public byte[] getAdditionalArgument() {
        return this.additionalArgument;
    }

    public void setAdditionalArgument(byte[] arg) {
        this.additionalArgument = arg;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeChar(109);
        dos.writeChar(100);
        dos.writeChar(79);
        dos.writeChar(80);
        dos.writeShort(this.deviceIdentifier);
        dos.writeShort(this.deviceAction);
        if (this.additionalArgument != null) {
            dos.writeShort(124);
            dos.writeShort((short)this.additionalArgument.length);
            dos.write(this.additionalArgument);
        } else {
            dos.writeShort(this.deviceParam);
        }
        return baos.toByteArray();
    }

    public static MassDeviceOperation fromByteArray(byte[] uMsg) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(uMsg);
        DataInputStream dis = new DataInputStream(bais);
        if (dis.readChar() != 'm' || dis.readChar() != 'd' || dis.readChar() != 'O' || dis.readChar() != 'P') {
            return null;
        }
        short dI = dis.readShort();
        short dA = dis.readShort();
        short dP = dis.readShort();
        byte[] aP = null;
        if (dP == 124) {
            short len = dis.readShort();
            aP = new byte[len];
            dis.read(aP);
        }
        return new MassDeviceOperation(dI, dA, dP, aP);
    }
}

