/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public class RegisteredDevices {
    private UUID sourceID;
    private short[] devices;

    public RegisteredDevices(UUID id, short[] devs) {
        this.sourceID = id;
        this.devices = devs;
    }

    public RegisteredDevices(UUID id, Set<Short> devs) {
        this.sourceID = id;
        this.devices = new short[devs.size()];
        Iterator<Short> ite = devs.iterator();
        for (int i = 0; i < this.devices.length; ++i) {
            this.devices[i] = ite.next();
        }
    }

    public UUID getNodeID() {
        return this.sourceID;
    }

    public Set<Short> getDevices() {
        HashSet<Short> set = new HashSet<Short>();
        for (int i = 0; i < this.devices.length; ++i) {
            set.add(this.devices[i]);
        }
        return set;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeChar(114);
        dos.writeChar(100);
        dos.writeChar(68);
        dos.writeChar(84);
        dos.writeLong(this.sourceID.getMostSignificantBits());
        dos.writeLong(this.sourceID.getLeastSignificantBits());
        dos.writeInt(this.devices.length);
        for (int i = 0; i < this.devices.length; ++i) {
            dos.writeShort(this.devices[i]);
        }
        return baos.toByteArray();
    }

    public byte[] serializeToMessage() {
        short len = (short)(18 + this.devices.length * 2);
        byte[] buffer = new byte[len];
        ByteBuffer buf = ByteBuffer.wrap(buffer).order(ByteOrder.BIG_ENDIAN);
        buf.putLong(this.sourceID.getMostSignificantBits());
        buf.putLong(this.sourceID.getLeastSignificantBits());
        buf.putShort((short)this.devices.length);
        for (int i = 0; i < this.devices.length; ++i) {
            buf.putShort(this.devices[i]);
        }
        return buffer;
    }

    public static RegisteredDevices fromByteArray(byte[] uMsg) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(uMsg);
        DataInputStream dis = new DataInputStream(bais);
        if (dis.readChar() != 'r' || dis.readChar() != 'd' || dis.readChar() != 'D' || dis.readChar() != 'T') {
            return null;
        }
        long msb = dis.readLong();
        long lsb = dis.readLong();
        UUID id = new UUID(msb, lsb);
        int len = dis.readInt();
        short[] devs = new short[len];
        for (int i = 0; i < len; ++i) {
            devs[i] = dis.readShort();
        }
        return new RegisteredDevices(id, devs);
    }
}

