/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class ForwardJoinMessage
extends ProtoMessage {
    public static final short MSG_CODE = 1403;
    private short ttl;
    private final Host newHost;
    public static final ISerializer<ForwardJoinMessage> serializer = new ISerializer<ForwardJoinMessage>(){

        @Override
        public void serialize(ForwardJoinMessage m4, ByteBuf out) throws IOException {
            out.writeShort(m4.ttl);
            Host.serializer.serialize(m4.newHost, out);
        }

        @Override
        public ForwardJoinMessage deserialize(ByteBuf in) throws IOException {
            short ttl = in.readShort();
            Host newHost = Host.serializer.deserialize(in);
            return new ForwardJoinMessage(ttl, newHost);
        }
    };

    public ForwardJoinMessage(short ttl, Host newHost) {
        super((short)1403);
        this.ttl = ttl;
        this.newHost = newHost;
    }

    public String toString() {
        return "ForwardJoinMessage{ttl=" + this.ttl + ", newHost=" + String.valueOf(this.newHost) + "}";
    }

    public Host getNewHost() {
        return this.newHost;
    }

    public short getTtl() {
        return this.ttl;
    }

    public short decrementTtl() {
        short s2 = this.ttl;
        this.ttl = (short)(s2 - 1);
        return s2;
    }
}

