/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.membership;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;
import java.util.UUID;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class Peer
extends Host
implements Cloneable {
    public static final int BYTES = 22;
    private final UUID peerID;
    public static ISerializer<Peer> serializer = new ISerializer<Peer>(){

        @Override
        public void serialize(Peer peer, ByteBuf out) throws IOException {
            Host.serializer.serialize(peer, out);
            out.writeLong(peer.peerID.getMostSignificantBits());
            out.writeLong(peer.peerID.getLeastSignificantBits());
        }

        @Override
        public Peer deserialize(ByteBuf in) throws IOException {
            Host h2 = Host.serializer.deserialize(in);
            UUID id = new UUID(in.readLong(), in.readLong());
            return new Peer(h2, id);
        }
    };

    public Peer(InetAddress address, int port) {
        super(address, port);
        this.peerID = UUID.randomUUID();
    }

    public Peer(InetAddress address, int port, UUID peerID) {
        super(address, port);
        this.peerID = peerID;
    }

    private Peer(Host h2, UUID peerID) {
        super(h2.getAddress(), h2.getPort());
        this.peerID = peerID;
    }

    private Peer(Host h2) {
        super(h2.getAddress(), h2.getPort());
        this.peerID = UUID.randomUUID();
    }

    public UUID getPeerID() {
        return this.peerID;
    }

    @Override
    public String toString() {
        return String.valueOf(this.peerID) + " (" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Host) {
            return super.equals(other);
        }
        if (!(other instanceof Peer)) {
            return false;
        }
        Peer p = (Peer)other;
        return super.equals(other) && this.peerID.equals(p.getPeerID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPort(), this.getAddress(), this.peerID.toString());
    }

    @Override
    public int compareTo(Peer other) {
        int cmp = Long.compare(this.peerID.getMostSignificantBits(), other.peerID.getMostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(this.peerID.getLeastSignificantBits(), other.peerID.getLeastSignificantBits());
    }

    public Peer clone() {
        return new Peer(this.getAddress(), this.getPort(), this.peerID);
    }
}

