/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.storage.notifications;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.protocols.storage.notifications.common.CommonDataNotification;
import pt.unl.fct.di.novasys.babel.protocols.storage.operations.utils.CommonOperationType;

public class JSONDataNotification
extends CommonDataNotification {
    public static final short NOTIFICATION_ID = 600;
    public static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Map.Entry.class, new MapEntryAdapter()).create();
    private String jsonString;
    private Class<? extends Object> resultType;

    public JSONDataNotification(CommonOperationType type, String keySpaceID, String collectionID, String objectID, Object value) {
        super(keySpaceID, collectionID, objectID, type, (short)600);
        this.jsonString = gson.toJson(value);
        this.resultType = value.getClass();
    }

    public JSONDataNotification(CommonOperationType type, String keySpaceID, String collectionID, String objectID, Object value, String message) {
        super(keySpaceID, collectionID, objectID, type, message, (short)600);
        this.jsonString = gson.toJson(value);
        this.resultType = value.getClass();
    }

    public String getResult() {
        return this.jsonString;
    }

    public Class<? extends Object> getResultType() {
        return this.resultType;
    }

    private static class MapEntryAdapter
    implements JsonSerializer<Map.Entry<?, ?>>,
    JsonDeserializer<Map.Entry<?, ?>> {
        private MapEntryAdapter() {
        }

        @Override
        public JsonElement serialize(Map.Entry<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("key", context.serialize(src.getKey()));
            obj.add("value", context.serialize(src.getValue()));
            return obj;
        }

        @Override
        public Map.Entry<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            Object key = context.deserialize(obj.get("key"), (Type)((Object)Object.class));
            Object value = context.deserialize(obj.get("value"), (Type)((Object)Object.class));
            return new AbstractMap.SimpleEntry(key, value);
        }
    }
}

