/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.memebership.monitor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleReply;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleRequest;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.listener.MembershipMonitorListener;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.timer.MembershipCheckTimer;
import pt.unl.fct.di.novasys.network.data.Host;

public class MembershipMonitor
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(MembershipMonitor.class);
    public static final short PROTOCOL_ID = 1666;
    public static final String PROTOCOL_NAME = "Membership-Monitor";
    public static final String PAR_MEMBERSHIP_CHECK_PERIOD = "Monitor.period";
    public static final String PAR_MEMBERSHIP_PROTO_ID = "Monitor.membership.id";
    public static final String PAR_MEMBERSHIP_SAMPLE_SIZE = "Monitor.membership.samplesize";
    public static final short DEFAULT_MEMBERSHIP_SAMPLE_SIZE = 10;
    private short membershipProtocolID = 0;
    private short sampleSize = (short)10;
    private final Set<MembershipMonitorListener> listeners = new HashSet<MembershipMonitorListener>();

    public MembershipMonitor() throws HandlerRegistrationException {
        super(PROTOCOL_NAME, (short)1666);
        this.registerTimerHandler((short)16661, this::handleMembershipCheckTimer);
        this.registerReplyHandler((short)402, this::handleGetNeighborSampleReply);
        this.subscribeNotification((short)401, this::handleNeighborUpNotification);
        this.subscribeNotification((short)402, this::handleNeighborDownNotification);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        long period;
        if (props.containsKey(PAR_MEMBERSHIP_SAMPLE_SIZE)) {
            this.sampleSize = Short.parseShort(props.getProperty(PAR_MEMBERSHIP_SAMPLE_SIZE));
        }
        if (props.containsKey(PAR_MEMBERSHIP_PROTO_ID)) {
            this.membershipProtocolID = Short.parseShort(props.getProperty(PAR_MEMBERSHIP_PROTO_ID));
        }
        if ((period = Long.parseLong(props.getProperty(PAR_MEMBERSHIP_CHECK_PERIOD, "0"))) > 0L && this.membershipProtocolID > 0) {
            this.setupPeriodicTimer(new MembershipCheckTimer(), period, period);
        }
    }

    public void addMembershipListener(MembershipMonitorListener l) {
        this.listeners.add(l);
    }

    private void handleMembershipCheckTimer(MembershipCheckTimer t2, long time) {
        logger.debug("Requesting (up to " + this.sampleSize + ") neighbors from protocol with id: " + this.membershipProtocolID);
        this.sendRequest(new GetNeighborsSampleRequest(this.sampleSize), this.membershipProtocolID);
    }

    private void handleNeighborUpNotification(NeighborUp not, short proto) {
        logger.info("Neighbor up: " + String.valueOf(not.getPeer()));
        for (MembershipMonitorListener l : this.listeners) {
            l.neighborUP(not.getPeer());
        }
    }

    private void handleNeighborDownNotification(NeighborDown not, short proto) {
        logger.info("Neighbor down: " + String.valueOf(not.getPeer()));
        for (MembershipMonitorListener l : this.listeners) {
            l.neighborDOWN(not.getPeer());
        }
    }

    private void handleGetNeighborSampleReply(GetNeighborsSampleReply r, short proto) {
        HashSet<Host> neigh = new HashSet<Host>();
        Iterator<? extends Host> neighbors = r.getSampleIterator();
        logger.info("Current Neighbors:");
        int i = 0;
        while (neighbors.hasNext()) {
            Host h2 = neighbors.next();
            neigh.add(h2);
            logger.info(i + ": " + String.valueOf(h2));
            ++i;
        }
        for (MembershipMonitorListener l : this.listeners) {
            l.currentNeighbors(neigh);
        }
    }
}

