/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.accrual;

import java.util.HashMap;
import java.util.Map;
import pt.unl.fct.di.novasys.channel.accrual.HeartbeatHistory;

public class PhiAccrual {
    private final HeartbeatHistory history;
    private final double threshold;
    private final int minStdDeviationMs;
    private final int acceptableHbPauseMs;
    private long lastHb = 0L;

    public PhiAccrual(int windowSize, double threshold, int minStdDeviationMs, int acceptableHbPauseMs, int firstHbEstimateMs) {
        this.history = new HeartbeatHistory(windowSize, firstHbEstimateMs);
        this.acceptableHbPauseMs = acceptableHbPauseMs;
        this.minStdDeviationMs = minStdDeviationMs;
        this.threshold = threshold;
    }

    public void receivedHb(long hbCounter) {
        long timestamp = System.currentTimeMillis();
        if (this.lastHb != 0L) {
            long interval = timestamp - this.lastHb;
            this.history.add(interval);
        }
        this.lastHb = timestamp;
    }

    public boolean isAvailable(long timestamp) {
        return this.threshold <= 0.0 || this.phi(timestamp).get("phi") < this.threshold;
    }

    public Map<String, Double> phi(long timestamp) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (this.lastHb == 0L) {
            res.put("timeDiff", 0.0);
            res.put("mean", 0.0);
            res.put("stdDev", 0.0);
            res.put("phi", 0.0);
        } else {
            long timeDiff = timestamp - this.lastHb;
            double mean = this.history.mean() + (double)this.acceptableHbPauseMs;
            double stdDev = Math.max(this.history.stdDev(), (double)this.minStdDeviationMs);
            res.put("timeDiff", Double.valueOf(timeDiff));
            res.put("mean", mean);
            res.put("stdDev", stdDev);
            res.put("phi", this.phi(timeDiff, mean, stdDev));
        }
        return res;
    }

    private double phi(long timeDiff, double mean, double stdDev) {
        double y = ((double)timeDiff - mean) / stdDev;
        double e = Math.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -Math.log10(e / (1.0 + e));
        }
        return -Math.log10(1.0 - 1.0 / (1.0 - e));
    }
}

