/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.ackos.messaging;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public class AckosAppMessage<T>
extends AckosMessage<T> {
    private final long id;
    private final T payload;
    public static final AckosMessage.IAckosSerializer serializer = new AckosMessage.IAckosSerializer<AckosAppMessage>(){

        @Override
        public void serialize(AckosAppMessage msg, ByteBuf out, ISerializer innerSerializer) throws IOException {
            out.writeLong(msg.id);
            innerSerializer.serialize(msg.payload, out);
        }

        @Override
        public AckosAppMessage deserialize(ByteBuf in, ISerializer innerSerializer) throws IOException {
            long id = in.readLong();
            Object payload = innerSerializer.deserialize(in);
            return new AckosAppMessage(id, payload);
        }
    };

    public AckosAppMessage(long id, T payload) {
        super(AckosMessage.Type.APP_MSG);
        this.id = id;
        this.payload = payload;
    }

    public T getPayload() {
        return this.payload;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "AckosAppMessage{id=" + this.id + ", payload=" + String.valueOf(this.payload) + "}";
    }
}

