/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.base;

import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.IChannel;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;

public abstract class SingleThreadedChannel<T, Y>
implements IChannel<T>,
MessageListener<Y> {
    private static final Logger logger = LogManager.getLogger(SingleThreadedChannel.class);
    protected final DefaultEventExecutor loop;

    public SingleThreadedChannel(String threadName) {
        this.loop = new DefaultEventExecutor(new DefaultThreadFactory(threadName));
    }

    @Override
    public void sendMessage(T msg, Host peer, int connection) {
        this.loop.execute(() -> this.onSendMessage(msg, peer, connection));
    }

    protected abstract void onSendMessage(T var1, Host var2, int var3);

    @Override
    public void closeConnection(Host peer, int connection) {
        this.loop.execute(() -> this.onCloseConnection(peer, connection));
    }

    protected abstract void onCloseConnection(Host var1, int var2);

    @Override
    public void deliverMessage(Y msg, Connection<Y> conn) {
        this.loop.execute(() -> this.onDeliverMessage(msg, conn));
    }

    protected abstract void onDeliverMessage(Y var1, Connection<Y> var2);

    @Override
    public void openConnection(Host peer, int connection) {
        this.loop.execute(() -> this.onOpenConnection(peer, connection));
    }

    protected abstract void onOpenConnection(Host var1, int var2);
}

