/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import pt.unl.fct.di.novasys.channel.secure.SecureChannelListener;
import pt.unl.fct.di.novasys.channel.secure.SecureSingleThreadedBiChannel;
import pt.unl.fct.di.novasys.channel.secure.auth.AuthSession;
import pt.unl.fct.di.novasys.channel.secure.auth.AuthenticatedMessage;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionFailed;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.exceptions.AuthenticationException;
import pt.unl.fct.di.novasys.channel.secure.exceptions.MessageAuthenticationException;
import pt.unl.fct.di.novasys.channel.secure.utils.ECPubKeySerializer;
import pt.unl.fct.di.novasys.channel.secure.utils.X509CertificateSerializer;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.listeners.InConnListener;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class AuthChannel<T>
extends SecureSingleThreadedBiChannel<T, AuthenticatedMessage>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(AuthChannel.class);
    public static final short CHANNEL_MAGIC_NUMBER = 21765;
    public static final String NAME = "AuthChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "worker_group";
    public static final String TRIGGER_SENT_KEY = "trigger_sent";
    public static final String METRICS_INTERVAL_KEY = "metrics_interval";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String LISTEN_ADDRESS_ATTR = "listen_address";
    public static final String CHANNELMAGIC_ATTR = "magic_number";
    public static final String DEFAULT_PORT = "9573";
    public static final String DEFAULT_HB_INTERVAL = "0";
    public static final String DEFAULT_HB_TOLERANCE = "0";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    public static final String DEFAULT_METRICS_INTERVAL = "-1";
    public static final int CONNECTION_OUT = 0;
    public static final int CONNECTION_IN = 1;
    private static final int HANDSHAKE_STEPS = 3;
    static final Provider PROVIDER = new BouncyCastleProvider();
    private final SecureRandom rng;
    private final NetworkManager<AuthenticatedMessage> network;
    private final Attributes baseAttributes;
    private final ISerializer<T> msgSerializer;
    private final SecureChannelListener<T> listener;
    private final X509IKeyManager keyManager;
    private final X509ITrustManager trustManager;
    private final boolean metrics;
    private final Map<Host, Set<Bytes>> hostIds;
    private final Map<Host, Bytes> defaultHostIds;
    private final Map<Long, AuthSession<T>> allSessions;
    private final Map<Bytes, Map<Long, AuthSession<T>>> inSessions;
    private final Map<Bytes, AuthSession<T>> outSessions;
    private final Map<Host, AuthSession<T>> pendingOutSessionsWithoutId;
    static final String ASYM_KEY_ALG = "RSA";
    static final String SYM_KEY_ALG = "AES";
    static final String MAC_ALG = "HmacSHA256";
    static final int MAC_BYTES = 32;
    private static final String EC_KDF_ALG = "ECCDHwithSHA256KDF";
    private static final String DH_EC_NAME = "prime192v1";
    private static final String CERT_ATTR = "certificate";
    private static final String DH_PUB_ATTR = "dh_pub";
    private static final String EXPECTED_ID_ATTR = "expected_identity";
    private static final String IV_ATTR = "iv";
    private static final String IV_SIG_ATTR = "iv_sig";
    private static final String ATTRS_SIG_ATTR = "attrs_sig";

    public AuthChannel(ISerializer<T> serializer, SecureChannelListener<T> listener, Properties properties, X509IKeyManager keyManager, X509ITrustManager trustManager) throws IOException {
        super(NAME);
        SecureRandom rngInst;
        try {
            rngInst = SecureRandom.getInstance("DEFAULT", PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Failed to get \"DEFAULT\" secure random");
            rngInst = new SecureRandom();
        }
        this.rng = rngInst;
        this.msgSerializer = serializer;
        this.listener = listener;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.hostIds = new HashMap<Host, Set<Bytes>>();
        this.defaultHostIds = new HashMap<Host, Bytes>();
        this.inSessions = new HashMap<Bytes, Map<Long, AuthSession<T>>>();
        this.outSessions = new HashMap<Bytes, AuthSession<T>>();
        this.allSessions = new HashMap<Long, AuthSession<T>>();
        this.pendingOutSessionsWithoutId = new HashMap<Host, AuthSession<T>>();
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("AuthChannel requires binding address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "0"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, "0"));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT));
        int metricsInterval = Integer.parseInt(properties.getProperty(METRICS_INTERVAL_KEY, DEFAULT_METRICS_INTERVAL));
        this.metrics = metricsInterval > 0;
        Host listenAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.baseAttributes = new Attributes();
        this.baseAttributes.putShort(CHANNELMAGIC_ATTR, (short)21765);
        this.baseAttributes.putHost(LISTEN_ADDRESS_ATTR, listenAddress);
        this.network = new NetworkManager<AuthenticatedMessage>(3, AuthenticatedMessage.getSerializer(32), this, hbInterval, hbTolerance, connTimeout, eventExecutors);
        this.network.createServerSocket((InConnListener<AuthenticatedMessage>)this, listenAddress, this.baseAttributes, (AttributeValidator)this, eventExecutors);
        if (this.metrics) {
            this.loop.scheduleAtFixedRate(this::triggerMetricsEvent, metricsInterval, metricsInterval, TimeUnit.MILLISECONDS);
        }
    }

    void triggerMetricsEvent() {
    }

    private Attributes createFirstHandshakeAttributes(ECPublicKey ecPubKey, byte[] iv, String idAlias, Optional<byte[]> expectedId) throws CertificateEncodingException, IOException, InvalidKeyException, SignatureException {
        try {
            Attributes attrs = this.baseAttributes.shallowClone();
            attrs.putBytes("identity", this.keyManager.getAliasId(idAlias));
            X509Certificate cert = this.keyManager.getCertificateChain(idAlias)[0];
            attrs.putObject(CERT_ATTR, cert, X509CertificateSerializer.INSTANCE);
            attrs.putObject(DH_PUB_ATTR, ecPubKey, ECPubKeySerializer.INSTANCE);
            expectedId.ifPresent(id -> attrs.putBytes(EXPECTED_ID_ATTR, (byte[])id));
            attrs.putBytes(IV_ATTR, iv);
            ByteBuf attrsBytes = Unpooled.buffer();
            Attributes.serializer.serialize(attrs, attrsBytes);
            Signature sig = Signature.getInstance(cert.getSigAlgName(), PROVIDER);
            sig.initSign(this.keyManager.getPrivateKey(idAlias));
            sig.update(attrsBytes.array());
            attrs.putBytes(ATTRS_SIG_ATTR, sig.sign());
            return attrs;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] signWithCert(X509Certificate cert, PrivateKey privKey, byte[] tbsBytes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance(cert.getSigAlgName(), PROVIDER);
        sig.initSign(privKey);
        sig.update(tbsBytes);
        return sig.sign();
    }

    private Attributes createSecondHandshakeAttributes(String idAlias, ECPublicKey dhPubKey, byte[] iv, byte[] peerIv) throws CertificateEncodingException, IOException, InvalidKeyException, SignatureException {
        try {
            Attributes attrs = this.baseAttributes.shallowClone();
            attrs.putBytes("identity", this.keyManager.getAliasId(idAlias));
            X509Certificate cert = this.keyManager.getCertificateChain(idAlias)[0];
            attrs.putObject(CERT_ATTR, cert, X509CertificateSerializer.INSTANCE);
            PrivateKey signingKey = this.keyManager.getPrivateKey(idAlias);
            byte[] signedPeerIv = this.signWithCert(cert, signingKey, peerIv);
            attrs.putBytes(IV_SIG_ATTR, signedPeerIv);
            attrs.putObject(DH_PUB_ATTR, dhPubKey, ECPubKeySerializer.INSTANCE);
            attrs.putBytes(IV_ATTR, iv);
            ByteBuf attrsBytes = Unpooled.buffer();
            Attributes.serializer.serialize(attrs, attrsBytes);
            Signature sig = Signature.getInstance(cert.getSigAlgName(), PROVIDER);
            sig.initSign(this.keyManager.getPrivateKey(idAlias));
            sig.update(attrsBytes.array());
            attrs.putBytes(ATTRS_SIG_ATTR, sig.sign());
            return attrs;
        }
        catch (NullPointerException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyPair generateECKeyPair() {
        try {
            Instant start = Instant.now();
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC", PROVIDER);
            keyPairGen.initialize(ECNamedCurveTable.getParameterSpec(DH_EC_NAME), this.rng);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            if (logger.isDebugEnabled()) {
                Instant end = Instant.now();
                logger.debug(() -> "Generated EC key pair in %sms (%sns)".formatted(ChronoUnit.MILLIS.between(start, end), ChronoUnit.NANOS.between(start, end)));
            }
            return keyPair;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private SecretKey generateAESFromECKeys(PrivateKey myPriv, PublicKey peerPub) throws InvalidKeyException {
        try {
            Instant start = logger.isDebugEnabled() ? Instant.now() : null;
            KeyAgreement keyAgreement = KeyAgreement.getInstance(EC_KDF_ALG, PROVIDER);
            keyAgreement.init((Key)myPriv, this.rng);
            keyAgreement.doPhase(peerPub, true);
            SecretKey secretKey = keyAgreement.generateSecret(SYM_KEY_ALG);
            if (logger.isDebugEnabled()) {
                Instant end = Instant.now();
                logger.debug("Generated {} secret key from ECDH in {}ms ({}ns): {}", (Object)SYM_KEY_ALG, (Object)ChronoUnit.MILLIS.between(start, end), (Object)ChronoUnit.NANOS.between(start, end), (Object)Hex.toHexString(secretKey.getEncoded()));
            }
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] generateIv(int size) {
        byte[] iv = new byte[size];
        this.rng.nextBytes(iv);
        return iv;
    }

    private AuthSession<T> createOutSession(Host peer, Optional<byte[]> expectedId) throws CertificateEncodingException, InvalidKeyException, SignatureException, IOException, InvalidAlgorithmParameterException {
        String idAlias = this.keyManager.chooseClientAlias(new String[]{ASYM_KEY_ALG}, null, null);
        KeyPair ecKeyPair = this.generateECKeyPair();
        byte[] iv = this.generateIv(32);
        Attributes attrs = this.createFirstHandshakeAttributes((ECPublicKey)ecKeyPair.getPublic(), iv, idAlias, expectedId);
        Connection<AuthenticatedMessage> conn = this.network.createConnection(peer, attrs, this, this);
        AuthSession<T> session = AuthSession.startOutSession(peer, conn, this.msgSerializer, idAlias, ecKeyPair, iv, expectedId);
        this.allSessions.put(conn.getConnectionId(), session);
        return session;
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        Short channel = attr.getShort(CHANNELMAGIC_ATTR);
        return channel != null && channel == 21765;
    }

    @Override
    public Attributes getSecondHandshakeAttributes(long channelId, Attributes peerAttr, Attributes myAttr) throws InvalidHandshakeAttributesException {
        try {
            return (Attributes)this.loop.submit(() -> this.onGetSecondHandshakeAttributes(channelId, peerAttr, myAttr)).get();
        }
        catch (ExecutionException e) {
            throw (InvalidHandshakeAttributesException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new InvalidHandshakeAttributesException(peerAttr, 1, (Throwable)e);
        }
    }

    private Attributes onGetSecondHandshakeAttributes(long channelId, Attributes peerAttr, Attributes myAttr) throws InvalidHandshakeAttributesException {
        logger.debug("Validating in connection attribute and creating reply attributes...");
        try {
            String idAlias;
            Host peerSocket = peerAttr.getHost(LISTEN_ADDRESS_ATTR);
            byte[] peerIv = peerAttr.getBytes(IV_ATTR);
            if (!this.validateAttributes(peerAttr) || peerSocket == null || peerIv == null) {
                throw new InvalidHandshakeAttributesException(peerAttr, "First handshake: missing attributes");
            }
            X509Certificate peerCert = peerAttr.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
            PublicKey peerPubKey = peerCert.getPublicKey();
            byte[] peerId = this.trustManager.extractIdFromCertificate(peerCert);
            if (!Arrays.equals(peerId, peerAttr.getBytes("identity"))) {
                logger.debug("In connection attribute validation failed: peer id in attributes ({}) differs from the one extracted from certificate ({})", (Object)Bytes.of(peerId), (Object)Bytes.of(peerAttr.getBytes("identity")));
                throw new InvalidHandshakeAttributesException(peerAttr, 1);
            }
            this.trustManager.checkClientTrusted(new X509Certificate[]{peerCert}, peerCert.getPublicKey().getAlgorithm());
            if (!this.verifyAttrSignature(peerAttr, peerPubKey, peerCert.getSigAlgName())) {
                logger.debug("In connection attribute validation failed: Invalid attributes signature");
                throw new InvalidHandshakeAttributesException(peerAttr, 1);
            }
            ECPublicKey peerDHPubKey = peerAttr.getObject(DH_PUB_ATTR, ECPubKeySerializer.INSTANCE);
            byte[] requestedId = peerAttr.getBytes(EXPECTED_ID_ATTR);
            idAlias = requestedId == null ? this.keyManager.chooseServerAlias(ASYM_KEY_ALG, null, null) : ((idAlias = this.keyManager.getIdAlias(requestedId)) == null ? this.keyManager.chooseServerAlias(ASYM_KEY_ALG, null, null) : idAlias);
            KeyPair ecKeyPair = this.generateECKeyPair();
            SecretKey secretKey = this.generateAESFromECKeys(ecKeyPair.getPrivate(), peerDHPubKey);
            byte[] iv = this.generateIv(32);
            Attributes attrs = this.createSecondHandshakeAttributes(idAlias, (ECPublicKey)ecKeyPair.getPublic(), iv, peerIv);
            AuthSession<T> session = AuthSession.startInSession(peerSocket, this.msgSerializer, idAlias, ecKeyPair, secretKey, iv, peerId, peerIv);
            this.allSessions.put(channelId, session);
            this.inSessions.computeIfAbsent(Bytes.of(peerId), __ -> new HashMap()).put(channelId, session);
            return attrs;
        }
        catch (IOException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            logger.debug("In connection attribute validation failed with exception: " + String.valueOf(e));
            throw new InvalidHandshakeAttributesException(peerAttr, 1, (Throwable)e);
        }
    }

    @Override
    public Attributes getNthHandshakeAttributes(long connectionId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeAttributesException {
        try {
            return (Attributes)this.loop.submit(() -> this.onGetNthHandshakeAttributes(connectionId, handshakeN, peerAttrs, mySentAttrs)).get();
        }
        catch (ExecutionException e) {
            throw (InvalidHandshakeAttributesException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), 1, (Throwable)e);
        }
    }

    public Attributes onGetNthHandshakeAttributes(long connectionId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeAttributesException {
        InvalidHandshakeAttributesException invalidHandshakeException = new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1);
        if (!this.validateAttributes(peerAttrs.getLast())) {
            throw invalidHandshakeException;
        }
        try {
            switch (handshakeN) {
                case 3: {
                    logger.trace("Getting 3rd handshake message...");
                    AuthSession<T> session = this.allSessions.get(connectionId);
                    Attributes secondHs = peerAttrs.getLast();
                    X509Certificate peerCert = secondHs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                    Bytes peerId = Bytes.of(secondHs.getBytes("identity"));
                    byte[] expectedId = secondHs.getBytes(EXPECTED_ID_ATTR);
                    String authType = peerCert.getPublicKey().getAlgorithm();
                    if (expectedId != null) {
                        if (!peerId.equals(expectedId)) {
                            throw new AuthenticationException("Expected peer id %s, but got peerId %s".formatted(Bytes.of(expectedId), peerId));
                        }
                        this.trustManager.checkServerTrusted(new X509Certificate[]{peerCert}, expectedId, authType);
                    } else {
                        this.trustManager.checkServerTrusted(new X509Certificate[]{peerCert}, authType);
                    }
                    this.verifyAttrSignature(secondHs, peerCert.getPublicKey(), peerCert.getSigAlgName());
                    byte[] signedIv = secondHs.getBytes(IV_SIG_ATTR);
                    if (!this.verifySignature(peerCert, signedIv, session.getMyLastMac())) {
                        throw invalidHandshakeException;
                    }
                    byte[] peerIv = secondHs.getBytes(IV_ATTR);
                    ECPublicKey peerDHPubKey = secondHs.getObject(DH_PUB_ATTR, ECPubKeySerializer.INSTANCE);
                    SecretKey sessionKey = this.generateAESFromECKeys(session.getDhKeyPair().getPrivate(), peerDHPubKey);
                    session.completeOutSessionSetup(peerId.array(), sessionKey, peerIv);
                    Attributes thirdHs = this.baseAttributes.shallowClone();
                    X509Certificate myCert = this.keyManager.getCertificateChain(session.getMyIdAlias())[0];
                    PrivateKey myPrivKey = this.keyManager.getPrivateKey(session.getMyIdAlias());
                    byte[] signedPeerIv = this.signWithCert(myCert, myPrivKey, peerIv);
                    thirdHs.putBytes(IV_SIG_ATTR, signedPeerIv);
                    return thirdHs;
                }
                case 4: {
                    logger.trace("Validating 3rd handshake message...");
                    AuthSession<T> session = this.allSessions.get(connectionId);
                    Attributes firstHs = peerAttrs.getFirst();
                    Attributes thirdHs = peerAttrs.getLast();
                    X509Certificate peerCert = firstHs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                    byte[] signedIv = thirdHs.getBytes(IV_SIG_ATTR);
                    if (this.verifySignature(peerCert, signedIv, session.getMyLastMac())) {
                        return Attributes.EMPTY;
                    }
                    throw invalidHandshakeException;
                }
            }
            throw invalidHandshakeException;
        }
        catch (IOException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | AuthenticationException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1, (Throwable)e);
        }
    }

    private boolean verifyAttrSignature(Attributes peerAttr, PublicKey peerPubKey, String sigAlg) throws NoSuchAlgorithmException, IOException {
        try {
            Attributes attrWithoutSignature = peerAttr.shallowClone();
            attrWithoutSignature.remove(ATTRS_SIG_ATTR);
            Signature sig = Signature.getInstance(sigAlg, PROVIDER);
            sig.initVerify(peerPubKey);
            ByteBuf attrBytes = Unpooled.buffer();
            Attributes.serializer.serialize(attrWithoutSignature, attrBytes);
            sig.update(attrBytes.array());
            return sig.verify(peerAttr.getBytes(ATTRS_SIG_ATTR));
        }
        catch (InvalidKeyException | SignatureException e) {
            return false;
        }
    }

    private boolean verifySignature(X509Certificate cert, byte[] signature, byte[] unsignedBytes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance(cert.getSigAlgName(), PROVIDER);
        sig.initVerify(cert);
        sig.update(unsignedBytes);
        return sig.verify(signature);
    }

    @Override
    protected void onDeliverMessage(AuthenticatedMessage authMsg, Connection<AuthenticatedMessage> conn) {
        Bytes peerId = Bytes.of(conn.getPeerAttributes().getBytes("identity"));
        if (peerId == null) {
            try {
                T droppedMsg = this.msgSerializer.deserialize(Unpooled.wrappedBuffer(authMsg.getData()));
                logger.error("onDeliverMessage error: No identity associated with connection to host {}. Dropping recvd msg: {}", (Object)conn.getPeer(), (Object)droppedMsg);
            }
            catch (IOException e) {
                logger.error("onDeliverMessage error: No identity associated with connection to host {}", (Object)conn.getPeer());
            }
            conn.disconnect();
            return;
        }
        AuthSession<T> session = this.allSessions.get(conn.getConnectionId());
        if (session == null) {
            try {
                T droppedMsg = this.msgSerializer.deserialize(Unpooled.wrappedBuffer(authMsg.getData()));
                logger.error("onDeliverMessage error: No session with peer {}. Dropping recvd msg: {}", (Object)conn.getPeer(), (Object)droppedMsg);
            }
            catch (IOException e) {
                logger.error("onDeliverMessage error: No session with peer {}", (Object)conn.getPeer());
            }
            conn.disconnect();
            return;
        }
        Host host = session.getPeerSocket();
        try {
            T msg = session.receiveMessage(authMsg);
            logger.debug("onDeliverMessage from: {} ({})", (Object)host, (Object)peerId);
            this.listener.deliverMessage(msg, host, peerId.array());
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | MessageAuthenticationException e) {
            logger.error("onDeliverMessage error: Exception on receiving message from {} ({})", (Object)host, (Object)peerId);
            e.printStackTrace();
        }
    }

    @Override
    protected void onSendMessage(T msg, Host host, int connection) {
        Bytes peerId = this.defaultHostIds.get(host);
        if (peerId == null && connection <= 0) {
            AuthSession<T> session = this.pendingOutSessionsWithoutId.get(host);
            if (session == null) {
                logger.debug("onSendMessage ignored: No connection to {}", (Object)host);
                this.listener.messageFailed(msg, host, new IllegalStateException("No connection to " + String.valueOf(host)));
            } else {
                assert (session.getState() == AuthSession.State.CONNECTING);
                session.enqueue(msg);
            }
        } else {
            this.onSendMessage(msg, peerId.array(), connection);
        }
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        Bytes peerId = this.defaultHostIds.get(peer);
        if (peerId == null) {
            logger.debug("onCloseConnection ignored: No open connection to {}", (Object)peer);
        } else {
            this.onCloseConnection(peerId.array(), connection);
        }
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        Set<Bytes> knownIds = this.hostIds.get(peer);
        if (this.pendingOutSessionsWithoutId.containsKey(peer) || knownIds != null && knownIds.stream().anyMatch(id -> this.outSessions.containsKey(id))) {
            logger.debug("onOpenConnection ignored: A default connection for {} already exists", (Object)peer);
        } else {
            this.onOpenConnection(peer, null, connection);
        }
    }

    private AuthSession<T> getSessionToSend(Bytes peerId, int connection) {
        if (connection == 1) {
            Map<Long, AuthSession<T>> sessions = this.inSessions.get(peerId);
            if (sessions != null) {
                return sessions.values().stream().findAny().orElse(null);
            }
        } else if (connection <= 0) {
            return this.outSessions.get(peerId);
        }
        return null;
    }

    private Bytes getPeerId(Connection<?> connection) {
        Attributes peerAttrs = connection.getPeerAttributes();
        byte[] advertisedId = peerAttrs != null ? peerAttrs.getBytes("identity") : null;
        return Bytes.of(advertisedId != null ? advertisedId : connection.getSelfAttributes().getBytes(EXPECTED_ID_ATTR));
    }

    private void addHostId(Host host, Bytes id) {
        this.hostIds.computeIfAbsent(host, k -> {
            this.defaultHostIds.put(host, id);
            return new HashSet();
        }).add(id);
    }

    private void pruneHostId(Host host, Bytes id) {
        if (this.outSessions.containsKey(id) && host.equals(this.outSessions.get(id).getPeerSocket()) || this.inSessions.containsKey(id) && this.inSessions.get(id).values().stream().anyMatch(s2 -> s2.getPeerSocket().equals(host))) {
            return;
        }
        Set<Bytes> ids = this.hostIds.get(host);
        if (ids == null) {
            return;
        }
        ids.remove(id);
        if (id.equals(this.defaultHostIds.get(host))) {
            if (ids.size() > 0) {
                this.defaultHostIds.put(host, ids.iterator().next());
            } else {
                this.defaultHostIds.remove(host);
                this.hostIds.remove(host);
            }
        }
    }

    @Override
    public void onSendMessage(T msg, byte[] peerId, int connection) {
        Bytes idBytes = Bytes.of(peerId);
        AuthSession<T> session = this.getSessionToSend(idBytes, connection);
        if (session == null) {
            logger.debug("onSendMessage: No session with peer {}. Dropping msg: {}", (Object)idBytes, (Object)msg);
            this.listener.messageFailed(msg, Optional.empty(), peerId, new IllegalArgumentException("No connection to " + String.valueOf(idBytes)));
            return;
        }
        Host peerSocket = session.getPeerSocket();
        logger.debug("onSendMessage: Sending message {} to {} ({})", (Object)msg, (Object)peerSocket, (Object)idBytes);
        switch (session.getState()) {
            case CONNECTED: {
                this.sendWithListener(session, msg, peerSocket, peerId);
                break;
            }
            case CONNECTING: {
                session.getMsgQueue().add(msg);
                break;
            }
            case DISCONNECTING: {
                this.listener.messageFailed(msg, Optional.of(peerSocket), peerId, new IllegalStateException("Channel state was DISCONNECTING"));
            }
        }
    }

    private void sendWithListener(AuthSession<T> session, T msg, Host peer, byte[] peerId) {
        Promise<Void> promise = this.loop.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess()) {
                this.listener.messageSent(msg, peer, peerId);
            } else if (!future.isSuccess()) {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, future.cause());
            }
        });
        try {
            session.macAndSend(msg, promise);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            logger.warn("Message MAC failed.");
            this.listener.messageFailed(msg, Optional.of(peer), peerId, e);
        }
    }

    @Override
    public void onCloseConnection(byte[] peerId, int connection) {
        Bytes idBytes = Bytes.of(peerId);
        AuthSession<T> session = this.outSessions.get(idBytes);
        if (session == null) {
            logger.debug("onCloseConnection ignored: No out connection to {}", (Object)idBytes);
        } else {
            logger.debug("onCloseConnection: {} ({})", (Object)session.getPeerSocket(), (Object)idBytes);
            session.disconect();
            this.outSessions.remove(idBytes);
            this.allSessions.remove(session.getConnectionId());
            this.pruneHostId(session.getPeerSocket(), idBytes);
        }
    }

    @Override
    public void onOpenConnection(Host peer, byte[] peerId, int connection) {
        try {
            Bytes idBytes = Bytes.of(peerId);
            if (this.outSessions.containsKey(idBytes)) {
                logger.debug("onOpenConnection ignored: Repeated connection to {} ({})", (Object)peer, (Object)idBytes);
                return;
            }
            logger.debug("onOpenConnection opening session to: {} ({})", (Object)peer, (Object)peerId);
            AuthSession<T> session = this.createOutSession(peer, Optional.ofNullable(peerId));
            if (peerId == null) {
                this.pendingOutSessionsWithoutId.put(peer, session);
            } else {
                this.outSessions.put(idBytes, session);
                this.addHostId(peer, idBytes);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | SignatureException | CertificateEncodingException e) {
            e.printStackTrace();
            this.onOutboundConnectionFailed((Connection<AuthenticatedMessage>)null, (Throwable)e);
        }
    }

    @Override
    protected void onInboundConnectionUp(Connection<AuthenticatedMessage> conn) {
        AuthSession<T> session = this.allSessions.get(conn.getConnectionId());
        if (session == null) {
            logger.warn("InboundConnectionUp with no prepared session.");
            conn.disconnect();
        }
        session.completeInSessionSetup(conn);
        session.setState(AuthSession.State.CONNECTED);
        Host host = session.getPeerSocket();
        Bytes peerIdBytes = Bytes.of(session.getPeerId());
        logger.debug("InboundConnectionUp with {} ({})", (Object)host, (Object)peerIdBytes);
        this.addHostId(host, peerIdBytes);
        this.listener.deliverEvent(new SecureInConnectionUp(host, session.getPeerId()));
    }

    @Override
    protected void onInboundConnectionDown(Connection<AuthenticatedMessage> con, Throwable cause) {
        Host host;
        Bytes peerId = this.getPeerId(con);
        try {
            host = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTR);
        }
        catch (IOException e) {
            host = con.getPeer();
        }
        logger.debug("Inbound connection down with {} ({})", (Object)host, (Object)peerId);
        this.inSessions.remove(peerId);
        this.allSessions.remove(con.getConnectionId());
        this.pruneHostId(host, peerId);
        this.listener.deliverEvent(new SecureInConnectionDown(host, peerId, cause));
    }

    @Override
    protected void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: {}", cause);
        }
    }

    @Override
    protected void onServerSocketClose(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket closed.");
        } else {
            logger.error("Server socket closed. Cause: {}", cause);
        }
    }

    @Override
    protected void onOutboundConnectionUp(Connection<AuthenticatedMessage> conn) {
        AuthSession<T> session = this.allSessions.get(conn.getConnectionId());
        if (session == null) {
            logger.warn("OutboundConnectionUp with no prepared session.");
            conn.disconnect();
            return;
        }
        Host host = session.getPeerSocket();
        Bytes peerId = Bytes.of(session.getPeerId());
        logger.debug("OutboundConnectionUp with {} ({})", (Object)host, (Object)peerId);
        if (!this.outSessions.containsKey(peerId)) {
            this.pendingOutSessionsWithoutId.remove(host);
            this.outSessions.put(peerId, session);
            this.addHostId(host, peerId);
        }
        Queue<T> msgQueue = session.getMsgQueue();
        while (!msgQueue.isEmpty()) {
            this.sendWithListener(session, msgQueue.remove(), host, peerId.array());
        }
        session.setState(AuthSession.State.CONNECTED);
        this.listener.deliverEvent(new SecureOutConnectionUp(host, peerId));
    }

    @Override
    protected void onOutboundConnectionDown(Connection<AuthenticatedMessage> conn, Throwable cause) {
        Bytes peerId = this.getPeerId(conn);
        logger.debug("OutboundConnectionDown with {} ({}).{}", (Object)conn.getPeer(), (Object)peerId, cause == null ? "" : "\nCause: " + String.valueOf(cause));
        this.outSessions.remove(peerId);
        AuthSession<T> session = this.allSessions.remove(conn.getConnectionId());
        if (session == null) {
            return;
        }
        if (session.getState() == AuthSession.State.CONNECTING) {
            throw new AssertionError((Object)("ConnectionDown in CONNECTING session state: " + String.valueOf(conn)));
        }
        Host host = conn.getPeer();
        this.pruneHostId(host, peerId);
        this.listener.deliverEvent(new SecureOutConnectionDown(host, peerId, cause));
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<AuthenticatedMessage> conn, Throwable cause) {
        AuthSession<T> session = this.allSessions.remove(conn.getConnectionId());
        if (session == null) {
            logger.debug("OutboundConnectionFailed to {}.{}", (Object)conn.getPeer(), cause == null ? "" : "\nCause: " + String.valueOf(cause));
            this.listener.deliverEvent(new SecureOutConnectionFailed(conn.getPeer(), new byte[0], new LinkedList(), cause));
            return;
        }
        Host host = session.getPeerSocket();
        byte[] peerId = session.getPeerId();
        peerId = peerId != null ? peerId : new byte[]{};
        Bytes idBytes = Bytes.of(peerId);
        logger.debug("OutboundConnectionFailed to {} ({}).{}", (Object)host, (Object)idBytes, cause == null ? "" : "\nCause: " + String.valueOf(cause));
        if (this.outSessions.remove(idBytes) == null) {
            this.pendingOutSessionsWithoutId.remove(host);
        }
        this.listener.deliverEvent(new SecureOutConnectionFailed<T>(host, peerId, session.getMsgQueue(), cause));
    }
}

