/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.secure.auth.AuthChannel;
import pt.unl.fct.di.novasys.channel.secure.auth.AuthenticatedMessage;
import pt.unl.fct.di.novasys.channel.secure.exceptions.AuthenticationException;
import pt.unl.fct.di.novasys.channel.secure.exceptions.MessageAuthenticationException;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.data.Host;

public class AuthSession<T> {
    private static final Logger logger = LogManager.getLogger(AuthSession.class);
    static final String ID_ATTR = "identity";
    private static final String DEFAULT_MAC_ALG = "HmacSHA256";
    private String macAlgorithm = "HmacSHA256";
    private Connection<AuthenticatedMessage> connection;
    private final Queue<T> msgQueue;
    private final ISerializer<T> serializer;
    private State state;
    private final KeyPair dhKeyPair;
    private final String myIdAlias;
    private final Host peerSocket;
    private byte[] peerId;
    private SecretKey sessionKey;
    private byte[] myLastMac;
    private byte[] peerLastMac;
    private Promise<Void> lastMsgPromise;

    private AuthSession(Host peerSocket, ISerializer<T> serializer, String myIdAlias, KeyPair dhKeyPair, byte[] myIv) {
        this.peerSocket = peerSocket;
        this.serializer = serializer;
        this.myIdAlias = myIdAlias;
        this.dhKeyPair = dhKeyPair;
        this.myLastMac = myIv;
        this.state = State.CONNECTING;
        this.msgQueue = new LinkedList<T>();
    }

    public static <T> AuthSession<T> startOutSession(Host peerSocket, Connection<AuthenticatedMessage> connection, ISerializer<T> serializer, String myIdAlias, KeyPair dhKeyPair, byte[] myIv, Optional<byte[]> expectedPeerId) {
        AuthSession<T> session = new AuthSession<T>(peerSocket, serializer, myIdAlias, dhKeyPair, myIv);
        expectedPeerId.ifPresent(id -> {
            session.peerId = id;
        });
        session.connection = connection;
        return session;
    }

    public static <T> AuthSession<T> startInSession(Host peerSocket, ISerializer<T> serializer, String myIdAlias, KeyPair dhKeyPair, SecretKey secretKey, byte[] myIv, byte[] peerId, byte[] peerIv) {
        AuthSession<T> session = new AuthSession<T>(peerSocket, serializer, myIdAlias, dhKeyPair, myIv);
        session.peerId = peerId;
        session.peerLastMac = peerIv;
        session.sessionKey = secretKey;
        logger.debug("Starting in session with my iv: {}\nand peer iv: {}", (Object)Bytes.of(myIv), (Object)Bytes.of(peerIv));
        return session;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public void completeOutSessionSetup(byte[] peerId, SecretKey sessionKey, byte[] peerIv) throws IOException, InvalidKeyException, NoSuchAlgorithmException, AuthenticationException {
        if (this.state != State.CONNECTING) {
            throw new IllegalStateException("Tried to complete a connection that was already completed.");
        }
        if (this.peerId != null && !Arrays.equals(this.peerId, peerId)) {
            throw new AuthenticationException("Expected peer id %s, but got %s".formatted(this.peerId, peerId));
        }
        this.peerId = peerId;
        this.sessionKey = sessionKey;
        this.peerLastMac = peerIv;
        logger.debug("Completing out session with my iv: {}\nand peer iv: {}", (Object)Bytes.of(this.myLastMac), (Object)Bytes.of(peerIv));
    }

    public void completeInSessionSetup(Connection<AuthenticatedMessage> connection) {
        if (this.state != State.CONNECTING) {
            throw new IllegalStateException("Tried to complete a connection that was already completed.");
        }
        this.connection = connection;
    }

    public void setState(State newState) {
        this.state = newState;
    }

    public void disconect() {
        this.state = State.DISCONNECTING;
        this.connection.disconnect();
    }

    public synchronized void macAndSend(T msg, Promise<Void> promise) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        ByteBuf encodedMsg = Unpooled.buffer();
        this.serializer.serialize(msg, encodedMsg);
        while (this.lastMsgPromise != null && !this.lastMsgPromise.isDone()) {
            try {
                this.lastMsgPromise.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Mac mac = Mac.getInstance(this.macAlgorithm, AuthChannel.PROVIDER);
        mac.init(this.sessionKey);
        mac.update(encodedMsg.array());
        mac.update(this.myLastMac);
        byte[] newMac = mac.doFinal();
        this.myLastMac = newMac;
        AuthenticatedMessage authMsg = new AuthenticatedMessage(encodedMsg.array(), newMac);
        this.connection.sendMessage(authMsg, promise);
    }

    public T receiveMessage(AuthenticatedMessage authMsg) throws NoSuchAlgorithmException, InvalidKeyException, MessageAuthenticationException, IOException {
        Mac mac = Mac.getInstance(this.macAlgorithm, AuthChannel.PROVIDER);
        mac.init(this.sessionKey);
        mac.update(authMsg.getData());
        mac.update(this.peerLastMac);
        byte[] expectedMac = mac.doFinal();
        if (Arrays.equals(authMsg.getMac(), expectedMac)) {
            this.peerLastMac = expectedMac;
            return this.serializer.deserialize(Unpooled.wrappedBuffer(authMsg.getData()));
        }
        HexFormat hex = HexFormat.of();
        throw new MessageAuthenticationException("Expected MAC %s but got %s.".formatted(hex.formatHex(expectedMac), hex.formatHex(authMsg.getMac())));
    }

    public Connection<AuthenticatedMessage> getConnection() {
        return this.connection;
    }

    public long getConnectionId() {
        return this.connection.getConnectionId();
    }

    public boolean enqueue(T msg) {
        return this.msgQueue.add(msg);
    }

    public Queue<T> getMsgQueue() {
        return this.msgQueue;
    }

    public State getState() {
        return this.state;
    }

    public KeyPair getDhKeyPair() {
        return this.dhKeyPair;
    }

    public SecretKey getSessionKey() {
        return this.sessionKey;
    }

    public String getMyIdAlias() {
        return this.myIdAlias;
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public byte[] getMyLastMac() {
        return this.myLastMac;
    }

    public byte[] getPeerLastMac() {
        return this.peerLastMac;
    }

    public Host getPeerSocket() {
        return this.peerSocket;
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

