/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.weakauth;

import java.util.LinkedList;
import java.util.Queue;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.data.Host;

public class IdentifiedConnectionState<T> {
    private final Connection<T> connection;
    private boolean authenticated;
    private boolean connected;
    private final Queue<T> queue;
    private final Host peerSocket;
    private byte[] peerId;

    public IdentifiedConnectionState(Connection<T> conn, Host peerSocket) {
        this.connection = conn;
        this.authenticated = false;
        this.connected = false;
        this.queue = new LinkedList<T>();
        this.peerSocket = peerSocket;
    }

    public IdentifiedConnectionState(Connection<T> conn, Host peerSocket, Queue<T> initialQueue) {
        this.connection = conn;
        this.authenticated = false;
        this.connected = false;
        this.queue = new LinkedList<T>(initialQueue);
        this.peerSocket = peerSocket;
    }

    public Connection<T> getConnection() {
        return this.connection;
    }

    public long getConnectionId() {
        return this.connection.getConnectionId();
    }

    public Queue<T> getQueue() {
        return this.queue;
    }

    public Host getPeerListenAddress() {
        return this.peerSocket;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated() {
        this.authenticated = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected() {
        this.connected = true;
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public void setPeerId(byte[] peerId) {
        this.peerId = peerId;
    }

    public void disconnect() {
        this.queue.clear();
        this.connection.disconnect();
        this.connected = false;
    }
}

