/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import pt.unl.fct.di.novasys.iot.device.Device;

public abstract class DigitalDevice
implements Device {
    protected final String name;
    protected final int ID;
    protected int line;
    protected final Context pi4j;
    protected DigitalInput dataIn;
    protected DigitalInput dataIn2;
    protected DigitalOutput dataOut;
    protected DigitalOutput clk;
    protected DigitalInputConfig dataInCfg;
    protected DigitalOutputConfig dataOutCfg;
    protected DigitalOutputConfig clkCfg;

    public DigitalDevice(Context pi4j, DigitalOutputConfig clkCfg, DigitalInputConfig dataInCfg, DigitalInputConfig dataIn2Cfg, DigitalOutputConfig dataOutCfg, String name, int ID) {
        this.pi4j = pi4j;
        this.name = name;
        this.ID = ID;
        if (clkCfg != null) {
            this.clkCfg = clkCfg;
            this.clk = pi4j.create(clkCfg);
            this.line = clkCfg.address();
        }
        if (dataInCfg != null) {
            this.dataIn = pi4j.create(dataInCfg);
            if (dataIn2Cfg != null) {
                this.dataIn2 = pi4j.create(dataIn2Cfg);
            }
            if (clkCfg == null) {
                this.line = dataInCfg.address();
            }
        } else if (dataOutCfg != null) {
            this.dataOut = pi4j.create(dataOutCfg);
            if (clkCfg == null) {
                this.line = dataOutCfg.address();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.ID;
    }

    public int getLineNumber() {
        return this.line;
    }

    protected void delayMicroseconds(int us) {
        long waitUntil = System.nanoTime() + (long)(us * 1000);
        while (waitUntil > System.nanoTime()) {
        }
    }

    protected void setDataPinOutput() {
        if (this.dataIn != null) {
            this.pi4j.shutdown(this.dataIn.getId());
            this.dataIn = null;
        }
        this.delayMicroseconds(50);
        if (this.dataOut == null) {
            this.dataOut = this.pi4j.create(this.dataOutCfg);
        }
    }

    protected void setDataPinInput() {
        if (this.dataOut != null) {
            this.pi4j.shutdown(this.dataOut.getId());
            this.dataOut = null;
        }
        this.delayMicroseconds(50);
        if (this.dataIn == null) {
            this.dataIn = this.pi4j.create(this.dataInCfg);
        }
    }

    public DigitalOutput getDataOutputPin() {
        return this.dataOut;
    }

    public DigitalInput getDataInputPin() {
        return this.dataIn;
    }

    public DigitalOutput getClockOutputPin() {
        return this.clk;
    }
}

