/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.analog;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;

public class GroveBaseHatADC {
    private final I2C i2c;
    private static GroveBaseHatADC instance;

    private GroveBaseHatADC(Context pi4j, int address) {
        this.i2c = pi4j.create((I2CConfig)((I2CConfigBuilder)((I2CConfigBuilder)I2C.newConfigBuilder(pi4j).id("grove-hat-adc")).name("Grove Base Hat ADC")).bus(1).device(address).build());
    }

    public static void initialize(Context pi4j, int address) {
        if (instance != null) {
            throw new IllegalStateException("Already initialized");
        }
        instance = new GroveBaseHatADC(pi4j, address);
    }

    public static GroveBaseHatADC getInstance(Context pi4j, int address) {
        if (instance == null) {
            GroveBaseHatADC.initialize(pi4j, address);
        }
        return instance;
    }

    public static GroveBaseHatADC getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Must call initialize(Context pi4j, int address) first or use getInstance(Context pi4j, int address)");
        }
        return instance;
    }

    public int readRaw(int channel) {
        int addr = 16 + channel;
        return this.readRegister(addr);
    }

    public int readVoltage(int channel) {
        int addr = 32 + channel;
        return this.readRegister(addr);
    }

    public int readRatio(int channel) {
        int addr = 48 + channel;
        return this.readRegister(addr);
    }

    private int readRegister(int register) {
        int word = this.i2c.readRegisterWord(register);
        return (word & 0xFF) << 8 | word >> 8 & 0xFF;
    }
}

