/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.digital;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import pt.unl.fct.di.novasys.iot.device.digital.DigitalOutputDevice;

public class Grove4DigitDisplay
extends DigitalOutputDevice {
    private static final byte ADDR_AUTO = 64;
    private static final byte ADDR_FIXED = 68;
    public static final byte BRIGHT_DARKEST = 0;
    public static final byte BRIGHT_TYPICAL = 2;
    public static final byte BRIGHTEST = 7;
    public static final short DIGITS = 4;
    private static byte[] tube_tab = new byte[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111, 119, 124, 57, 94, 121, 113};
    private int cmd_set_data;
    private int cmd_set_addr;
    private int cmd_disp_ctrl;
    private boolean pointFlag = true;

    public Grove4DigitDisplay(Context pi4j, String name, int line, int ID) {
        super(pi4j, (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name + "_clk")).name(name + "_clk \u2014\u00a0" + ID)).address(line)).initial(DigitalState.LOW).build(), (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInput.newConfigBuilder(pi4j).id(name + "_in")).name(name + " \u2014\u00a0" + ID)).address(line + 1)).build(), (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name + "_out")).name(name + " \u2014\u00a0" + ID)).address(line + 1)).initial(DigitalState.LOW).build(), ID);
        this.set(2, 64, 192);
        this.clearDisplay();
    }

    private int writeByte(byte b) {
        for (int i = 0; i < 8; ++i) {
            this.clk.state(DigitalState.LOW);
            if ((b & 1) == 1) {
                this.dataOut.state(DigitalState.HIGH);
            } else {
                this.dataOut.state(DigitalState.LOW);
            }
            b = (byte)(b >> 1);
            this.clk.state(DigitalState.HIGH);
        }
        this.clk.state(DigitalState.LOW);
        this.dataOut.state(DigitalState.HIGH);
        this.clk.state(DigitalState.HIGH);
        this.setDataPinInput();
        this.delayMicroseconds(50);
        int ack = this.dataIn.isLow() ? 0 : 1;
        this.setDataPinOutput();
        this.delayMicroseconds(50);
        if (ack == 0) {
            this.dataOut.state(DigitalState.LOW);
        }
        this.delayMicroseconds(100);
        return ack;
    }

    public void display(byte[] disp_data) {
        byte[] seg_data = this.coding(disp_data);
        this.start();
        this.writeByte((byte)64);
        this.stop();
        this.start();
        this.writeByte((byte)this.cmd_set_addr);
        for (int i = 0; i < 4; ++i) {
            this.writeByte(seg_data[i]);
        }
        this.stop();
        this.start();
        this.writeByte((byte)this.unsignedByte(this.cmd_disp_ctrl));
        this.stop();
    }

    public void display(int bit_addr, byte disp_data) {
        byte seg_data = this.coding(disp_data);
        this.start();
        this.writeByte((byte)68);
        this.stop();
        this.start();
        this.writeByte((byte)(this.unsignedByte(bit_addr) | 0xC0));
        this.writeByte(seg_data);
        this.stop();
        this.start();
        this.writeByte((byte)this.cmd_disp_ctrl);
        this.stop();
    }

    public void displayNum(float num, int decimal, boolean minus) {
        int number = (int)Math.round((double)Math.abs(num) * Math.pow(10.0, decimal));
        if (decimal == 2) {
            this.point(true);
        } else {
            this.point(false);
        }
        for (int i = 0; i < 4 - (minus && num < 0.0f ? 1 : 0); ++i) {
            int j = 4 - i - 1;
            if (number != 0) {
                this.display(this.unsignedByte(j), (byte)(number % 10));
            } else {
                this.display(this.unsignedByte(j), (byte)127);
            }
            number /= 10;
        }
        if (minus && num < 0.0f) {
            this.display(0, (byte)45);
        }
    }

    void displayStr(String str, int loop_delay) throws InterruptedException {
        int end = str.length();
        if (end <= 4) {
            for (int i = 0; i < 4; ++i) {
                if (i < 0 || i >= end) {
                    this.display(i, (byte)127);
                    continue;
                }
                this.display(i, (byte)str.charAt(i));
            }
        } else {
            int offset = -4;
            for (int i = 0; i <= end + 4; ++i) {
                int j = offset;
                int k = 0;
                while (j < 4 + offset) {
                    if (j < 0 || j >= end) {
                        this.display(k, (byte)127);
                    } else {
                        this.display(k, (byte)str.charAt(j));
                    }
                    ++j;
                    ++k;
                }
                ++offset;
                Thread.sleep(loop_delay);
            }
        }
    }

    public void point(boolean point) {
        this.pointFlag = point;
    }

    private byte[] coding(byte[] disp_data) {
        for (int i = 0; i < 4; ++i) {
            disp_data[i] = this.coding(disp_data[i]);
        }
        return disp_data;
    }

    private byte coding(byte disp_data) {
        disp_data = disp_data == 127 ? (byte)0 : (disp_data >= 0 && disp_data < tube_tab.length ? tube_tab[disp_data] : (disp_data >= 48 && disp_data <= 57 ? tube_tab[disp_data - 48] : (byte)this.unsignedByte(this.char2segments((char)disp_data))));
        disp_data = (byte)(disp_data + (this.pointFlag ? 128 : 0));
        return disp_data;
    }

    private int char2segments(char c) {
        switch (c) {
            case '_': {
                return 8;
            }
            case '^': {
                return 1;
            }
            case '-': {
                return 64;
            }
            case '*': {
                return 99;
            }
            case ' ': {
                return 0;
            }
            case 'A': {
                return 119;
            }
            case 'a': {
                return 95;
            }
            case 'B': 
            case 'b': {
                return 124;
            }
            case 'C': {
                return 57;
            }
            case 'c': {
                return 88;
            }
            case 'D': 
            case 'd': {
                return 94;
            }
            case 'E': 
            case 'e': {
                return 121;
            }
            case 'F': 
            case 'f': {
                return 113;
            }
            case 'G': 
            case 'g': {
                return 53;
            }
            case 'H': {
                return 118;
            }
            case 'h': {
                return 116;
            }
            case 'I': {
                return 6;
            }
            case 'i': {
                return 4;
            }
            case 'J': {
                return 30;
            }
            case 'j': {
                return 22;
            }
            case 'K': 
            case 'k': {
                return 117;
            }
            case 'L': 
            case 'l': {
                return 56;
            }
            case 'M': 
            case 'm': {
                return 55;
            }
            case 'N': 
            case 'n': {
                return 84;
            }
            case 'O': 
            case 'o': {
                return 92;
            }
            case 'P': 
            case 'p': {
                return 115;
            }
            case 'Q': {
                return 123;
            }
            case 'q': {
                return 103;
            }
            case 'R': 
            case 'r': {
                return 80;
            }
            case 'S': 
            case 's': {
                return 109;
            }
            case 'T': 
            case 't': {
                return 120;
            }
            case 'U': 
            case 'u': {
                return 28;
            }
            case 'V': 
            case 'v': {
                return 62;
            }
            case 'W': {
                return 126;
            }
            case 'w': {
                return 42;
            }
            case 'X': 
            case 'x': {
                return 118;
            }
            case 'Y': 
            case 'y': {
                return 110;
            }
            case 'Z': 
            case 'z': {
                return 27;
            }
        }
        return 0;
    }

    public void clearDisplay() {
        this.display(0, (byte)127);
        this.display(1, (byte)127);
        this.display(2, (byte)127);
        this.display(3, (byte)127);
    }

    public void start() {
        this.dataOut.state(DigitalState.HIGH);
        this.clk.state(DigitalState.HIGH);
        this.dataOut.state(DigitalState.LOW);
        this.clk.state(DigitalState.LOW);
    }

    public void stop() {
        this.dataOut.state(DigitalState.LOW);
        this.clk.state(DigitalState.LOW);
        this.dataOut.state(DigitalState.HIGH);
        this.clk.state(DigitalState.HIGH);
    }

    public void set(int brightness, int set_data, int set_addr) {
        this.cmd_set_data = set_data;
        this.cmd_set_addr = set_addr;
        this.cmd_disp_ctrl = this.unsignedByte(brightness) + 136;
    }

    private int unsignedByte(byte b) {
        return b & 0xFF;
    }

    private int unsignedByte(short b) {
        return b & 0xFF;
    }

    private int unsignedByte(int b) {
        return b & 0xFF;
    }
}

