/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.digital;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import pt.unl.fct.di.novasys.iot.device.digital.DigitalOutputDevice;

public class GroveChainableRGB
extends DigitalOutputDevice {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int PULSE_DELAY = 20;
    private int numLeds;
    private byte[] ledState;

    public GroveChainableRGB(Context pi4j, String name, int line, int ID, int numLeds) {
        super(pi4j, (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name + "_clk")).name(name + "_clk \u2014\u00a0" + ID)).address(line)).initial(DigitalState.LOW).build(), (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name)).name(name + " \u2014\u00a0" + ID)).address(line + 1)).initial(DigitalState.LOW).build(), ID);
        this.numLeds = numLeds;
        this.ledState = new byte[numLeds * 3];
        for (byte i = 0; i < numLeds; i = (byte)(i + 1)) {
            this.setColorRGB(i, (byte)0, (byte)0, (byte)0);
        }
    }

    public void clk() {
        this.clk.state(DigitalState.LOW);
        this.delayMicroseconds(20);
        this.clk.state(DigitalState.HIGH);
        this.delayMicroseconds(20);
    }

    private void sendByte(byte b) {
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            if ((b & 0x80) != 0) {
                this.dataOut.state(DigitalState.HIGH);
            } else {
                this.dataOut.state(DigitalState.LOW);
            }
            this.clk();
            b = (byte)(b << 1);
        }
    }

    private void sendColor(byte red, byte green, byte blue) {
        int prefix = 192;
        if ((blue & 0x80) == 0) {
            prefix = (short)(prefix | 0x20);
        }
        if ((blue & 0x40) == 0) {
            prefix = (short)(prefix | 0x10);
        }
        if ((green & 0x80) == 0) {
            prefix = (short)(prefix | 8);
        }
        if ((green & 0x40) == 0) {
            prefix = (short)(prefix | 4);
        }
        if ((red & 0x80) == 0) {
            prefix = (short)(prefix | 2);
        }
        if ((red & 0x40) == 0) {
            prefix = (short)(prefix | 1);
        }
        this.sendByte((byte)prefix);
        this.sendByte(blue);
        this.sendByte(green);
        this.sendByte(red);
    }

    public void setColorRGB(byte led, byte red, byte green, byte blue) {
        this.sendByte((byte)0);
        this.sendByte((byte)0);
        this.sendByte((byte)0);
        this.sendByte((byte)0);
        for (int i = 0; i < this.numLeds; i = (int)((byte)(i + 1))) {
            if (i == led) {
                this.ledState[i * 3 + 0] = red;
                this.ledState[i * 3 + 1] = green;
                this.ledState[i * 3 + 2] = blue;
            }
            this.sendColor(this.ledState[i * 3 + 0], this.ledState[i * 3 + 1], this.ledState[i * 3 + 2]);
        }
        this.sendByte((byte)0);
        this.sendByte((byte)0);
        this.sendByte((byte)0);
        this.sendByte((byte)0);
    }

    public void setColorHSB(byte led, float hue, float saturation, float brightness) {
        float r;
        float g2;
        float b;
        Math.clamp(hue, 0.0f, 1.0f);
        Math.clamp(saturation, 0.0f, 1.0f);
        Math.clamp(brightness, 0.0f, 1.0f);
        if ((double)saturation == 0.0) {
            g2 = b = brightness;
            r = b;
        } else {
            float q = brightness < 0.5f ? brightness * (1.0f + saturation) : brightness + saturation - brightness * saturation;
            float p = 2.0f * brightness - q;
            r = this.hue2rgb(p, q, hue + 0.33333334f);
            g2 = this.hue2rgb(p, q, hue);
            b = this.hue2rgb(p, q, hue - 0.33333334f);
        }
        this.setColorRGB(led, (byte)(255.0 * (double)r), (byte)(255.0 * (double)g2), (byte)(255.0 * (double)b));
    }

    private float hue2rgb(float p, float q, float t2) {
        if ((double)t2 < 0.0) {
            t2 = (float)((double)t2 + 1.0);
        }
        if ((double)t2 > 1.0) {
            t2 = (float)((double)t2 - 1.0);
        }
        if ((double)t2 < 0.16666666666666666) {
            return p + (q - p) * 6.0f * t2;
        }
        if ((double)t2 < 0.5) {
            return q;
        }
        if ((double)t2 < 0.6666666666666666) {
            return p + (q - p) * (0.6666667f - t2) * 6.0f;
        }
        return p;
    }

    public int getNumLeds() {
        return this.numLeds;
    }
}

