/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.digital;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import com.pi4j.io.gpio.digital.PullResistance;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import pt.unl.fct.di.novasys.iot.device.digital.DigitalInputDevice;

public class GroveEncoder
extends DigitalInputDevice {
    private final int threshold;
    private final AtomicInteger rotation;
    private final AtomicBoolean readyMsg;
    private final ScheduledExecutorService scheduler;
    private int ticks;
    private Rotation lastRotation;

    public GroveEncoder(Context pi4j, String name, int line, int ID, int threshold) {
        super(pi4j, (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInput.newConfigBuilder(pi4j).id(name + "_A")).name(name + " _A_\u00a0" + ID)).address(line)).pull(PullResistance.PULL_UP).build(), (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInput.newConfigBuilder(pi4j).id(name + "_B")).name(name + " _B_\u00a0" + ID + "1")).address(line + 1)).pull(PullResistance.PULL_UP).build(), ID);
        this.threshold = threshold;
        this.rotation = new AtomicInteger(Rotation.NONE.getValue());
        this.readyMsg = new AtomicBoolean(false);
        this.ticks = 0;
        this.lastRotation = Rotation.NONE;
        this.scheduler = Executors.newScheduledThreadPool(1);
        if (threshold > 0) {
            this.dataIn.addListener(this::onChangeThreshold);
            this.dataIn2.addListener(this::onChangeThreshold);
        } else {
            this.dataIn.addListener(this::onChange);
            this.dataIn2.addListener(this::onChange);
        }
        this.scheduler.scheduleAtFixedRate(() -> {
            boolean b;
            boolean a = this.dataIn.state() == DigitalState.HIGH;
            boolean bl = b = this.dataIn2.state() == DigitalState.HIGH;
            if (a && b) {
                this.readyMsg.set(true);
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    public GroveEncoder(Context pi4j, String name, int line, int ID) {
        this(pi4j, name, line, ID, 0);
    }

    private void onChange(DigitalStateChangeEvent<DigitalInput> event) {
        if (this.readyMsg.get()) {
            boolean b;
            boolean a = this.dataIn.state() == DigitalState.HIGH;
            boolean bl = b = this.dataIn2.state() == DigitalState.HIGH;
            if (a && !b) {
                this.rotation.set(Rotation.CLOCKWISE.getValue());
                this.readyMsg.set(false);
            } else if (!a && b) {
                this.rotation.set(Rotation.COUNTER_CLOCKWISE.getValue());
                this.readyMsg.set(false);
            }
        }
    }

    private void onChangeThreshold(DigitalStateChangeEvent<DigitalInput> event) {
        if (this.readyMsg.get()) {
            boolean a = this.dataIn.state() == DigitalState.HIGH;
            boolean b = this.dataIn2.state() == DigitalState.HIGH;
            Rotation currentRotation = Rotation.NONE;
            if (a && !b) {
                currentRotation = Rotation.CLOCKWISE;
            } else if (!a && b) {
                currentRotation = Rotation.COUNTER_CLOCKWISE;
            }
            if (currentRotation != Rotation.NONE) {
                if (currentRotation != this.lastRotation) {
                    this.ticks = 1;
                    this.lastRotation = currentRotation;
                } else if (++this.ticks >= this.threshold) {
                    this.rotation.set(currentRotation.getValue());
                    this.ticks = 0;
                }
                this.readyMsg.set(false);
            }
        }
    }

    public Rotation getRotation() {
        return Rotation.fromValue(this.rotation.getAndSet(Rotation.NONE.getValue()));
    }

    public static enum Rotation {
        NONE(0),
        CLOCKWISE(1),
        COUNTER_CLOCKWISE(2);

        public final int value;

        private Rotation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Rotation fromValue(int value) {
            for (Rotation r : Rotation.values()) {
                if (r.value != value) continue;
                return r;
            }
            return NONE;
        }
    }
}

