/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.digital;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import pt.unl.fct.di.novasys.iot.device.digital.DigitalOutputDevice;

public class GroveLEDBar
extends DigitalOutputDevice {
    private static final int LED_MAX_COUNT = 24;
    private static final int LED_COUNT = 10;
    private boolean reverse;
    private int showCount;
    private int[] led;
    private static final int LED_TURN_OFF = 0;
    private static final int LED_FULL_BRIGHTNESS = 255;

    public GroveLEDBar(Context pi4j, String name, int line, int ID, boolean reverse) {
        super(pi4j, (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name + "_clk")).name(name + "_clk \u2014\u00a0" + ID)).address(line)).initial(DigitalState.LOW).build(), (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name)).name(name + " \u2014\u00a0" + ID)).address(line + 1)).initial(DigitalState.LOW).build(), ID);
        this.reverse = reverse;
        this.showCount = 10;
        this.led = new int[24];
        for (int i = 0; i < 24; ++i) {
            this.led[i] = 0;
        }
    }

    private void send(int bits) {
        bits &= 0xFFFF;
        boolean clkState = false;
        for (int i = 0; i < 16; ++i) {
            this.dataOut.state((bits & 0x8000) != 0 ? DigitalState.HIGH : DigitalState.LOW);
            this.clk.state(clkState ? DigitalState.HIGH : DigitalState.LOW);
            clkState = !clkState;
            bits <<= 1;
        }
    }

    private void send() {
        if (this.reverse) {
            this.send(0);
            int i = this.showCount;
            while (i-- > 0) {
                this.send(this.led[i]);
            }
            for (i = 0; i < 12 - this.showCount; ++i) {
                this.send(0);
            }
        } else {
            this.send(0);
            for (int i = 0; i < 12; ++i) {
                this.send(this.led[i]);
            }
        }
        this.latch();
    }

    private void latch() {
        this.dataOut.state(DigitalState.LOW);
        this.clk.state(DigitalState.HIGH);
        this.clk.state(DigitalState.LOW);
        this.clk.state(DigitalState.HIGH);
        this.clk.state(DigitalState.LOW);
        this.delayMicroseconds(240);
        this.dataOut.state(DigitalState.HIGH);
        this.dataOut.state(DigitalState.LOW);
        this.dataOut.state(DigitalState.HIGH);
        this.dataOut.state(DigitalState.LOW);
        this.dataOut.state(DigitalState.HIGH);
        this.dataOut.state(DigitalState.LOW);
        this.dataOut.state(DigitalState.HIGH);
        this.dataOut.state(DigitalState.LOW);
        this.delayMicroseconds(1);
        this.clk.state(DigitalState.HIGH);
        this.clk.state(DigitalState.LOW);
    }

    public void setLevel(float level) {
        int i;
        level = Math.max(0.0f, Math.min(level, (float)this.showCount));
        level *= 8.0f;
        for (i = 0; i < this.showCount; ++i) {
            this.led[i] = level > 8.0f ? -1 : (level > 0.0f ? ~(-1 << (byte)level) : 0);
            level -= 8.0f;
        }
        for (i = this.showCount; i < 10; ++i) {
            this.led[i] = 0;
        }
        this.send();
    }

    public void setLED(int ledNum, float brightness) {
        ledNum = Math.max(1, Math.min(ledNum, this.showCount));
        brightness = Math.max(0.0f, Math.min(brightness, 1.0f));
        this.led[ledNum - 1] = ~(-1 << ((int)(brightness * 8.0f) & 0xFF));
        this.send();
    }

    public void toggleLED(int ledNum) {
        int i = ledNum <= this.showCount ? ledNum - 1 : this.showCount - 1;
        this.led[i] = this.led[i] != 0 ? 0 : 255;
        this.send();
    }

    public void setBits(int value) {
        int i = 0;
        while (i < 10) {
            this.led[i] = (value & 1) != 0 ? 255 : 0;
            ++i;
            value >>= 1;
        }
        this.send();
    }

    public void setLEDNum(int count) {
        this.showCount = count;
        for (int i = count; i < 10; ++i) {
            this.led[i] = 0;
        }
    }

    public void setGreenToRed(boolean reverse) {
        this.reverse = reverse;
        this.send();
    }

    public int getBits() {
        int val = 0;
        for (int i = 0; i < this.showCount; ++i) {
            if (this.led[i] == 0) continue;
            val |= 1 << i;
        }
        return val;
    }
}

