/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.digital;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import pt.unl.fct.di.novasys.iot.device.digital.DigitalInputDevice;

public class GroveUltrasonicRanger
extends DigitalInputDevice {
    public GroveUltrasonicRanger(Context pi4j, String name, int line, int ID) {
        super(pi4j, (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInput.newConfigBuilder(pi4j).id(name + "_in")).name(name + " \u2014\u00a0" + ID)).address(line)).build(), (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutput.newConfigBuilder(pi4j).id(name + "_out")).name(name + " \u2014\u00a0" + ID)).address(line)).initial(DigitalState.LOW).build(), ID);
    }

    private long pulseIn(long timeout) {
        long start = System.nanoTime();
        while (this.dataIn.isHigh()) {
            if ((System.nanoTime() - start) / 1000L < timeout) continue;
            return 0L;
        }
        while (this.dataIn.isLow()) {
            if ((System.nanoTime() - start) / 1000L < timeout) continue;
            return 0L;
        }
        long pulseStart = System.nanoTime();
        while (this.dataIn.isHigh()) {
            if ((System.nanoTime() - start) / 1000L < timeout) continue;
            return 0L;
        }
        long pulseEnd = System.nanoTime();
        return (pulseEnd - pulseStart) / 1000L;
    }

    private long duration(long timeout) {
        this.setDataPinOutput();
        this.dataOut.state(DigitalState.LOW);
        this.delayMicroseconds(2);
        this.dataOut.state(DigitalState.HIGH);
        this.delayMicroseconds(5);
        this.dataOut.state(DigitalState.LOW);
        this.setDataPinInput();
        return this.pulseIn(timeout);
    }

    public long measureInCentimeters() {
        return this.measureInCentimeters(1000000L);
    }

    public long measureInCentimeters(long timeout) {
        long range = this.duration(timeout) / 29L / 2L;
        return range;
    }

    public long measureInMillimeters() {
        return this.measureInMillimeters(1000000L);
    }

    public long measureInMillimeters(long timeout) {
        long range = this.duration(timeout) * 5L / 29L;
        return range;
    }

    public long measureInInches() {
        return this.measureInInches(1000000L);
    }

    public long measureInInches(long timeout) {
        long range = this.duration(timeout) / 74L / 2L;
        return range;
    }
}

