/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class Grove3AxisAccelerometer
implements I2CDevice {
    public static final int MMA7660_ADDR = 76;
    public static final int MMA7660_X = 0;
    public static final int MMA7660_Y = 1;
    public static final int MMA7660_Z = 2;
    public static final int MMA7660_TILT = 3;
    public static final int MMA7660_SRST = 4;
    public static final int MMA7660_SPCNT = 5;
    public static final int MMA7660_INTSU = 6;
    public static final int MMA7660_SHINTX = 128;
    public static final int MMA7660_SHINTY = 64;
    public static final int MMA7660_SHINTZ = 32;
    public static final int MMA7660_GINT = 16;
    public static final int MMA7660_ASINT = 8;
    public static final int MMA7660_PDINT = 4;
    public static final int MMA7660_PLINT = 2;
    public static final int MMA7660_FBINT = 1;
    public static final int MMA7660_MODE = 7;
    public static final int MMA7660_STAND_BY = 0;
    public static final int MMA7660_ACTIVE = 1;
    public static final int MMA7660_SR = 8;
    public static final int AUTO_SLEEP_120 = 0;
    public static final int AUTO_SLEEP_64 = 1;
    public static final int AUTO_SLEEP_32 = 2;
    public static final int AUTO_SLEEP_16 = 3;
    public static final int AUTO_SLEEP_8 = 4;
    public static final int AUTO_SLEEP_4 = 5;
    public static final int AUTO_SLEEP_2 = 6;
    public static final int AUTO_SLEEP_1 = 7;
    public static final int MMA7660_PDET = 9;
    public static final int MMA7660_PD = 10;
    public static final int MMA7660_TIMEOUT = 500;
    private final I2C accelerometer;
    private AccelLookup[] accLookup;

    public Grove3AxisAccelerometer(Context pi4j) throws IOException {
        I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
        configtext.id("Grovepi-plus76");
        configtext.name("My I2C Bus 76");
        configtext.bus(1);
        configtext.device(76);
        I2CConfig c = (I2CConfig)configtext.build();
        this.accelerometer = pi4j.create(c);
        this.accLookup = new AccelLookup[64];
        for (int i = 0; i < this.accLookup.length; ++i) {
            this.accLookup[i] = new AccelLookup(this);
        }
        this.init();
    }

    private void setMode(int mode) {
        byte[] cmd = new byte[]{7, (byte)mode};
        this.accelerometer.write(cmd);
    }

    private void setSampleRate(int rate) {
        byte[] cmd = new byte[]{8, (byte)rate};
        this.accelerometer.write(cmd);
    }

    private void initAccelTable() {
        int i;
        double val = 0.0;
        for (i = 0; i < 32; ++i) {
            this.accLookup[i].g = (float)val;
            val += 0.047;
        }
        val = -0.047;
        for (i = 63; i > 31; --i) {
            this.accLookup[i].g = (float)val;
            val -= 0.047;
        }
        val = 0.0;
        double valZ = 90.0;
        for (i = 0; i < 22; ++i) {
            this.accLookup[i].xyAngle = (float)val;
            this.accLookup[i].zAngle = (float)valZ;
            val += 2.69;
            valZ -= 2.69;
        }
        val = -2.69;
        valZ = -87.31;
        for (i = 63; i > 42; --i) {
            this.accLookup[i].xyAngle = (float)val;
            this.accLookup[i].zAngle = (float)valZ;
            val -= 2.69;
            valZ += 2.69;
        }
        for (i = 22; i < 43; ++i) {
            this.accLookup[i].xyAngle = 255.0f;
            this.accLookup[i].zAngle = 255.0f;
        }
    }

    protected void init() throws IOException {
        this.initAccelTable();
        this.setMode(0);
        this.setSampleRate(2);
        this.setMode(1);
    }

    public int[] getXYZ() {
        byte[] val = new byte[3];
        int count = 0;
        boolean reset = true;
        boolean done = false;
        long start = System.nanoTime();
        block0: while (!done) {
            if (reset) {
                count = 0;
                val[2] = 64;
                val[1] = 64;
                val[0] = 64;
                start = System.nanoTime();
                reset = false;
            }
            while (true) {
                if (count < 3) {
                    while (val[count] > 63) {
                        this.accelerometer.read(val);
                        if ((System.nanoTime() - start) / 1000L <= 500L) continue;
                        reset = true;
                        break;
                    }
                    if (reset) {
                        continue block0;
                    }
                } else {
                    done = true;
                    continue block0;
                }
                ++count;
            }
        }
        int[] xyz = new int[]{(byte)(val[0] << 2) / 4, (byte)(val[1] << 2) / 4, (byte)(val[2] << 2) / 4};
        return xyz;
    }

    public float[] getAcceleration() {
        float[] a_xyz = new float[3];
        int[] xyz = this.getXYZ();
        a_xyz[0] = (float)xyz[0] / 21.0f;
        a_xyz[1] = (float)xyz[1] / 21.0f;
        a_xyz[2] = (float)xyz[2] / 21.0f;
        return a_xyz;
    }

    public AccelData getAccelerationData() {
        boolean error;
        byte[] val = new byte[3];
        block0: do {
            error = false;
            for (int count = 0; count < 3; ++count) {
                this.accelerometer.read(val);
                if ((0x40 & val[count]) != 64) continue;
                error = true;
                continue block0;
            }
        } while (error);
        AccelLookup x = this.accLookup[val[0] & 0x3F];
        AccelLookup y = this.accLookup[val[1] & 0x3F];
        AccelLookup z = this.accLookup[val[2] & 0x3F];
        return new AccelData(x, y, z);
    }

    public MMA7660Data getAllData() {
        byte[] data_buf = new byte[11];
        this.accelerometer.read(data_buf);
        MMA7660Data data = new MMA7660Data(data_buf[0] & 0xFF, data_buf[1] & 0xFF, data_buf[2] & 0xFF, data_buf[3] & 0xFF, data_buf[4] & 0xFF, data_buf[5] & 0xFF, data_buf[6] & 0xFF, data_buf[7] & 0xFF, data_buf[8] & 0xFF, data_buf[9] & 0xFF, data_buf[10] & 0xFF);
        return data;
    }

    public void close() {
        this.accelerometer.close();
    }

    private class AccelLookup {
        public float g;
        public float xyAngle;
        public float zAngle;

        AccelLookup(Grove3AxisAccelerometer grove3AxisAccelerometer) {
        }

        public String toString() {
            return String.format("g= %f, xyAngle= %f, zAngle= %f", Float.valueOf(this.g), Float.valueOf(this.xyAngle), Float.valueOf(this.zAngle));
        }
    }

    public record AccelData(AccelLookup x, AccelLookup y, AccelLookup z) {
        @Override
        public String toString() {
            return String.format("x: %s\ny: %s\nz: %s", this.x, this.y, this.z);
        }
    }

    public record MMA7660Data(int x, int y, int z, int tilt, int srst, int spcnt, int intsu, int mode, int sr, int pdet, int pd) {
    }
}

