/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class GroveBarometer
implements I2CDevice {
    public static final int STANDARD_SEA_LEVEL = 101325;
    private static final int BMP280_ADDRESS = 119;
    private static final int BMP280_REG_DIG_T1 = 136;
    private static final int BMP280_REG_DIG_T2 = 138;
    private static final int BMP280_REG_DIG_T3 = 140;
    private static final int BMP280_REG_DIG_P1 = 142;
    private static final int BMP280_REG_DIG_P2 = 144;
    private static final int BMP280_REG_DIG_P3 = 146;
    private static final int BMP280_REG_DIG_P4 = 148;
    private static final int BMP280_REG_DIG_P5 = 150;
    private static final int BMP280_REG_DIG_P6 = 152;
    private static final int BMP280_REG_DIG_P7 = 154;
    private static final int BMP280_REG_DIG_P8 = 156;
    private static final int BMP280_REG_DIG_P9 = 158;
    private static final int BMP280_REG_CHIPID = 208;
    private static final int BMP280_REG_VERSION = 209;
    private static final int BMP280_REG_SOFTRESET = 224;
    private static final int BMP280_REG_CONTROL = 244;
    private static final int BMP280_REG_CONFIG = 245;
    private static final int BMP280_REG_PRESSUREDATA = 247;
    private static final int BMP280_REG_TEMPDATA = 250;
    private final I2C barometer;
    private boolean transportOK;
    private int dig_T1;
    private short dig_T2;
    private short dig_T3;
    private int dig_P1;
    private short dig_P2;
    private short dig_P3;
    private short dig_P4;
    private short dig_P5;
    private short dig_P6;
    private short dig_P7;
    private short dig_P8;
    private short dig_P9;
    private int t_fine;

    public GroveBarometer(Context pi4j) throws IOException {
        I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
        configtext.id("Grovepi-plus119");
        configtext.name("My I2C Bus 119");
        configtext.bus(1);
        configtext.device(119);
        I2CConfig c = (I2CConfig)configtext.build();
        this.barometer = pi4j.create(c);
        this.init();
    }

    private void init() {
        this.dig_T1 = this.read16LE(136);
        this.dig_T2 = (short)this.read16LE(138);
        this.dig_T3 = (short)this.read16LE(140);
        this.dig_P1 = this.read16LE(142);
        this.dig_P2 = (short)this.read16LE(144);
        this.dig_P3 = (short)this.read16LE(146);
        this.dig_P4 = (short)this.read16LE(148);
        this.dig_P5 = (short)this.read16LE(150);
        this.dig_P6 = (short)this.read16LE(152);
        this.dig_P7 = (short)this.read16LE(154);
        this.dig_P8 = (short)this.read16LE(156);
        this.dig_P9 = (short)this.read16LE(158);
        this.barometer.writeRegister(244, 63);
    }

    private byte read8(int reg) {
        return (byte)this.barometer.readRegister(reg);
    }

    private int read16(int reg) {
        return this.barometer.readRegisterWord(reg);
    }

    private int read16LE(int reg) {
        int word = this.barometer.readRegisterWord(reg);
        return (word & 0xFF) << 8 | word >> 8 & 0xFF;
    }

    private int read24(int reg) {
        byte[] buf = this.barometer.readRegisterNBytes(reg, 3);
        int data = buf[0] & 0xFF;
        data <<= 8;
        data |= buf[1] & 0xFF;
        data <<= 8;
        return data |= buf[2] & 0xFF;
    }

    public double getTemperature() {
        int adcT = this.read24(250);
        int var1 = (((adcT >>= 4) >> 3) - (this.dig_T1 << 1)) * this.dig_T2 >> 11;
        int var2 = (((adcT >> 4) - this.dig_T1) * ((adcT >> 4) - this.dig_T1) >> 12) * this.dig_T3 >> 14;
        this.t_fine = var1 + var2;
        double T = this.t_fine * 5 + 128 >> 8;
        return T / 100.0;
    }

    public long getPressure() {
        this.getTemperature();
        int adcP = this.read24(247);
        adcP >>= 4;
        long var1 = (long)this.t_fine - 128000L;
        long var2 = var1 * var1 * (long)this.dig_P6;
        var2 += var1 * (long)this.dig_P5 << 17;
        var2 += (long)this.dig_P4 << 35;
        var1 = (var1 * var1 * (long)this.dig_P3 >> 8) + (var1 * (long)this.dig_P2 << 12);
        var1 = (0x800000000000L + var1) * (long)this.dig_P1 >> 33;
        if (var1 == 0L) {
            return 0L;
        }
        long p = 0x100000 - adcP;
        p = ((p << 31) - var2) * 3125L / var1;
        var1 = (long)this.dig_P9 * (p >> 13) * (p >> 13) >> 25;
        var2 = (long)this.dig_P8 * p >> 19;
        p = (p + var1 + var2 >> 8) + ((long)this.dig_P7 << 4);
        long result = p / 256L & 0xFFFFFFFFL;
        return result;
    }

    public double calcAltitude() {
        double t2 = this.getTemperature();
        double p1 = this.getPressure();
        return this.calcAltitude(101325.0, p1, t2);
    }

    public double calcAltitude(double p0) {
        double t2 = this.getTemperature();
        double p1 = this.getPressure();
        return this.calcAltitude(p0, p1, t2);
    }

    public double calcAltitude(double p0, double p1, double t2) {
        double C2 = p0 / p1;
        C2 = Math.pow(C2, 0.1902630958088845) - 1.0;
        C2 = C2 * (t2 + 273.15) / 0.0065;
        return C2;
    }

    public BarometerData getBarometerData(double pressure) {
        return new BarometerData(this.getTemperature(), this.getPressure(), this.calcAltitude(pressure));
    }

    public BarometerData getBarometerData() {
        return new BarometerData(this.getTemperature(), this.getPressure(), this.calcAltitude());
    }

    public record BarometerData(double temperature, long pressure, double altitude) {
        @Override
        public String toString() {
            return String.format("Temperature (\u00baC): %.2f\nPressure (Pa): %d\nAltitude (m): %.2f", this.temperature, this.pressure, this.altitude);
        }
    }
}

