/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class GroveGestureDetector
implements I2CDevice {
    public static final int PAJ7620_ADDR = 115;
    public static final byte PAJ7620_REG_BANK_SEL = -17;
    public static final byte PAJ7620_REG_RESULT_L = 67;
    public static final byte PAJ7620_REG_RESULT_H = 68;
    public static final int PAJ7620_GESTURE_COUNT = 9;
    private static final int[][] initRegister = new int[][]{{239, 0}, {55, 7}, {56, 23}, {57, 6}, {66, 1}, {70, 45}, {71, 15}, {72, 60}, {73, 0}, {74, 30}, {76, 32}, {81, 16}, {94, 16}, {96, 39}, {128, 66}, {129, 68}, {130, 4}, {139, 1}, {144, 6}, {149, 10}, {150, 12}, {151, 5}, {154, 20}, {156, 63}, {165, 25}, {204, 25}, {205, 11}, {206, 19}, {207, 100}, {208, 33}, {239, 1}, {2, 15}, {3, 16}, {4, 2}, {37, 1}, {39, 57}, {40, 127}, {41, 8}, {62, 255}, {94, 61}, {101, 150}, {103, 151}, {105, 205}, {106, 1}, {109, 44}, {110, 1}, {114, 1}, {115, 53}, {119, 1}, {239, 0}};
    private final I2C detector;

    public GroveGestureDetector(Context pi4j) throws IOException {
        I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
        configtext.id("Grovepi-plus115");
        configtext.name("My I2C Bus 115");
        configtext.bus(1);
        configtext.device(115);
        I2CConfig c = (I2CConfig)configtext.build();
        this.detector = pi4j.create(c);
        this.init();
    }

    protected void init() throws IOException {
        byte[] cmd = new byte[]{-1, 0};
        this.detector.write(cmd);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.detector.readRegister(1) != 118 || this.detector.readRegister(0) != 32) {
            throw new IOException("Invalid values in the registers");
        }
        for (int i = 0; i < initRegister.length; ++i) {
            byte[] cmd1 = new byte[]{(byte)initRegister[i][0], (byte)initRegister[i][1]};
            this.detector.write(cmd1);
        }
        this.setReportMode(PAJ7620ReportMode.FAR_240FPS);
    }

    public PAJ7620GestureType getGesture() {
        PAJ7620GestureType gesture = null;
        int code = (this.detector.readRegister(68) << 8) + this.detector.readRegister(67);
        if (code == 0) {
            return null;
        }
        for (int i = PAJ7620GestureType.UP.code; i < 9; ++i) {
            if (code != 1 << i) continue;
            gesture = PAJ7620GestureType.values()[i];
            this.detector.readRegister(68);
            this.detector.readRegister(67);
            break;
        }
        return gesture;
    }

    protected boolean setReportMode(PAJ7620ReportMode mode) {
        int idleTime = 0;
        byte[] cmd = new byte[]{-17, 1};
        this.detector.write(cmd);
        switch (mode.ordinal()) {
            case 0: {
                idleTime = 53;
                break;
            }
            case 1: {
                idleTime = 183;
                break;
            }
            case 2: {
                idleTime = 18;
                break;
            }
            case 3: {
                idleTime = 148;
                break;
            }
            default: {
                return false;
            }
        }
        byte[] cmd1 = new byte[]{101, (byte)(idleTime & 0xFF)};
        this.detector.write(cmd1);
        byte[] cmd2 = new byte[]{-17, 0};
        this.detector.write(cmd2);
        return true;
    }

    public static enum PAJ7620ReportMode {
        FAR_240FPS(0),
        FAR_120FPS(1),
        NEAR_240FPS(2),
        NEAR_120FPS(3);

        public final int code;

        private PAJ7620ReportMode(int code) {
            this.code = code;
        }
    }

    public static enum PAJ7620GestureType {
        UP(0),
        DOWN(1),
        LEFT(2),
        RIGHT(3),
        PUSH(4),
        PULL(5),
        CLOCKWISE(6),
        COUNTER_CLOCKWISE(7),
        WAVE(8);

        public final int code;

        private PAJ7620GestureType(int code) {
            this.code = code;
        }
    }
}

