/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class GroveI2CHub8
implements I2CDevice {
    private static final int TCA9548_ADDRESS = 112;
    private final I2C hub;
    private int channels;

    public GroveI2CHub8(Context pi4j) throws IOException {
        I2CConfig config = (I2CConfig)((I2CConfigBuilder)((I2CConfigBuilder)I2C.newConfigBuilder(pi4j).id("Grovepi-plus112")).name("My I2C Bus 112")).bus(1).device(112).build();
        this.hub = pi4j.create(config);
        this.init();
    }

    private void init() {
        this.closeAll();
    }

    public void closeAll() {
        this.channels = 0;
        this.hub.write(this.channels);
    }

    public void openAll() {
        this.channels = 255;
        this.hub.write(this.channels);
    }

    public void closeChannel(TCAChannel channel) {
        this.channels ^= channel.getValue();
        this.hub.write(this.channels);
    }

    public void openChannel(TCAChannel channel) {
        this.channels |= channel.getValue();
        this.hub.write(this.channels);
    }

    public static enum TCAChannel {
        _0(1),
        _1(2),
        _2(4),
        _3(8),
        _4(16),
        _5(32),
        _6(64),
        _7(128);

        private final int value;

        private TCAChannel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

