/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class GroveLedMatrix
implements I2CDevice {
    public static final int LED_DISPLAY_ADDR = 101;
    private final I2C matrix;
    public static final byte red = 0;
    public static final byte orange = 18;
    public static final byte yellow = 24;
    public static final byte green = 82;
    public static final byte cyan = 127;
    public static final byte blue = -86;
    public static final byte purple = -61;
    public static final byte pink = -36;
    public static final byte white = -2;
    public static final byte black = -1;
    private static final byte I2C_CMD_CONTINUE_DATA = -127;
    private static final byte GROVE_TWO_RGB_LED_MATRIX_DEF_I2C_ADDR = 101;
    private static final int GROVE_TWO_RGB_LED_MATRIX_VID = 10374;
    private static final int GROVE_TWO_RGB_LED_MATRIX_PID = 32773;
    private static final byte I2C_CMD_GET_DEV_ID = 0;
    private static final byte I2C_CMD_DISP_BAR = 1;
    private static final byte I2C_CMD_DISP_EMOJI = 2;
    private static final byte I2C_CMD_DISP_NUM = 3;
    private static final byte I2C_CMD_DISP_STR = 4;
    private static final byte I2C_CMD_DISP_CUSTOM = 5;
    private static final byte I2C_CMD_DISP_OFF = 6;
    private static final byte I2C_CMD_DISP_ASCII = 7;
    private static final byte I2C_CMD_DISP_FLASH = 8;
    private static final byte I2C_CMD_DISP_COLOR_BAR = 9;
    private static final byte I2C_CMD_DISP_COLOR_WAVE = 10;
    private static final byte I2C_CMD_DISP_COLOR_CLOCKWISE = 11;
    private static final byte I2C_CMD_DISP_COLOR_ANIMATION = 12;
    private static final byte I2C_CMD_DISP_COLOR_BLOCK = 13;
    private static final byte I2C_CMD_STORE_FLASH = -96;
    private static final byte I2C_CMD_DELETE_FLASH = -95;
    private static final byte I2C_CMD_LED_ON = -80;
    private static final byte I2C_CMD_LED_OFF = -79;
    private static final byte I2C_CMD_AUTO_SLEEP_ON = -78;
    private static final byte I2C_CMD_AUTO_SLEEP_OFF = -77;
    private static final byte I2C_CMD_DISP_ROTATE = -76;
    private static final byte I2C_CMD_DISP_OFFSET = -75;
    private static final byte I2C_CMD_SET_ADDR = -64;
    private static final byte I2C_CMD_RST_ADDR = -63;
    private static final byte I2C_CMD_TEST_TX_RX_ON = -32;
    private static final byte I2C_CMD_TEST_TX_RX_OFF = -31;
    private static final byte I2C_CMD_TEST_GET_VER = -30;
    private static final byte I2C_CMD_GET_DEVICE_UID = -15;
    private static final byte ORIENTATION_DISPLAY_ROTATE_0 = 0;
    private static final byte ORIENTATION_DISPLAY_ROTATE_90 = 1;
    private static final byte ORIENTATION_DISPLAY_ROTATE_180 = 2;
    private static final byte ORIENTATION_DISPLAY_ROTATE_270 = 3;
    private byte[] display;

    public GroveLedMatrix(Context pi4j) throws IOException {
        I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
        configtext.id("Grovepi-plus101");
        configtext.name("My I2C Bus 101");
        configtext.bus(1);
        configtext.device(101);
        I2CConfig c = (I2CConfig)configtext.build();
        this.matrix = pi4j.create(c);
        this.init();
    }

    protected void init() throws IOException {
        this.matrix.write((byte)-80);
        this.display = new byte[64];
        this.clearDisplay();
    }

    private void refreshDisplay() {
        byte[] cmd = new byte[75];
        cmd[0] = 5;
        cmd[1] = 0;
        cmd[2] = 0;
        cmd[3] = 1;
        cmd[4] = 1;
        cmd[5] = 0;
        cmd[6] = 0;
        cmd[7] = 0;
        System.arraycopy(this.display, 0, cmd, 8, 64);
        cmd[72] = -1;
        cmd[73] = -1;
        cmd[74] = 1;
        this.matrix.write(cmd);
    }

    public void clearDisplay() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.display[i * 8 + j] = -1;
            }
        }
        this.refreshDisplay();
    }

    public void setDisplayOrientation(Orientation orientation) {
        byte[] cmd = new byte[]{-76, orientation.code};
        this.matrix.write(cmd);
    }

    public void setAllColor(byte red, byte green, byte blue) {
        byte[] cmd = new byte[]{13, red, green, blue, 15, 15, 1};
        this.matrix.write(cmd);
    }

    public void setPixelColor(int x, int y, byte color) throws Exception {
        if (x < 0 || x >= 8 || y < 0 || y >= 8) {
            throw new Exception("Invalid coordinate (coordinates should be between [0,8[");
        }
        this.display[x * 8 + y] = color;
        this.refreshDisplay();
    }

    public void displayEmoji(Emoji emoji) {
        byte[] cmd = new byte[75];
        cmd[0] = 2;
        cmd[1] = (byte)emoji.code;
        cmd[2] = 1;
        cmd[3] = 1;
        cmd[4] = 1;
        System.arraycopy(this.display, 0, cmd, 8, 64);
        this.matrix.write(cmd);
    }

    public void displayColorBar(int bar) {
        byte[] cmd = new byte[75];
        cmd[0] = 9;
        cmd[1] = (byte)bar;
        cmd[2] = 1;
        cmd[3] = 1;
        cmd[4] = 1;
        System.arraycopy(this.display, 0, cmd, 8, 64);
        this.matrix.write(cmd);
    }

    public void displayColorAnimation(Animation animation) {
        int from;
        byte[] cmd = new byte[75];
        cmd[0] = 12;
        int to = switch (animation.code) {
            case 0 -> {
                from = 0;
                yield 28;
            }
            case 1 -> {
                from = 29;
                yield 41;
            }
            case 2 -> {
                from = 255;
                yield 255;
            }
            case 3 -> {
                from = 254;
                yield 254;
            }
            case 4 -> {
                from = 42;
                yield 43;
            }
            case 5 -> {
                from = 44;
                yield 52;
            }
            default -> {
                from = 0;
                yield 28;
            }
        };
        cmd[1] = (byte)from;
        cmd[2] = (byte)to;
        cmd[3] = 1;
        cmd[4] = 1;
        cmd[5] = 1;
        System.arraycopy(this.display, 0, cmd, 8, 64);
        this.matrix.write(cmd);
    }

    public byte[] getSnapshot() {
        return (byte[])this.display.clone();
    }

    public void loadSnapshot(byte[] snapshot) {
        if (this.display.length == snapshot.length) {
            System.arraycopy(snapshot, 0, this.display, 0, this.display.length);
            this.refreshDisplay();
        }
    }

    public void close() {
        this.matrix.close();
    }

    public static enum Orientation {
        ZeroDegrees(0),
        NinetyDegrees(1),
        OneEightyDegrees(2),
        TwoSeventyDegrees(3);

        public final byte code;

        private Orientation(byte code) {
            this.code = code;
        }
    }

    public static enum Emoji {
        Smile(0),
        Laught(1),
        Sad(2),
        Mad(3),
        Angry(4),
        Cry(5),
        Greedy(6),
        Cood(7),
        Shy(8),
        Awkward(9),
        Heart(10),
        SmallHeart(11),
        BrokenHeart(12),
        Waterdrop(13),
        Flame(14),
        Creeper(15),
        MadCreeper(16),
        Sword(17),
        WoodenSword(18),
        CrystalSword(19),
        House(20),
        Tree(21),
        Flower(22),
        Umbrella(23),
        Rain(24),
        Monster(25),
        Crab(26),
        Duck(27),
        Rabbit(28),
        Cat(29);

        public final int code;

        private Emoji(int code) {
            this.code = code;
        }
    }

    public static enum Animation {
        BigClock(0),
        SmallClock(1),
        Rainbow(2),
        Fire(3),
        WalkingChild(4),
        BrokenHeart(5);

        public final int code;

        private Animation(int code) {
            this.code = code;
        }
    }
}

