/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c;

import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import com.github.yafna.raspberry.grovepi.pi4j.IO;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import pt.unl.fct.di.novasys.iot.device.I2CDevice;

public class GroveRgbLcd
extends com.github.yafna.raspberry.grovepi.devices.GroveRgbLcd
implements I2CDevice {
    private final I2C rgb;
    private final I2C text;
    private Thread scrolling;
    private static final String spacing = "    ";
    private static final long scrool_time = 800L;
    private static final short lcd_char_limit = 32;
    private AtomicBoolean runText;

    public GroveRgbLcd(Context pi4j) throws IOException {
        I2CConfigBuilder configrgb = I2C.newConfigBuilder(pi4j);
        configrgb.id("Grovepi-plus98");
        configrgb.name("My I2C Bus 98");
        configrgb.bus(1);
        configrgb.device(98);
        I2CConfig c = (I2CConfig)configrgb.build();
        this.rgb = pi4j.create(c);
        I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
        configtext.id("Grovepi-plus62");
        configtext.name("My I2C Bus 62");
        configtext.bus(1);
        configtext.device(62);
        c = (I2CConfig)configtext.build();
        this.text = pi4j.create(c);
        this.init();
        this.scrolling = null;
        this.runText = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.rgb.close();
        this.text.close();
    }

    @Override
    public synchronized void setText(String s2) {
        if (this.runText.getAcquire()) {
            this.runText.set(false);
            try {
                this.scrolling.join();
            }
            catch (InterruptedException e) {
                this.scrolling.interrupt();
            }
        }
        if (s2.trim().length() > 32) {
            this.setScrollingText(s2.trim());
        } else {
            try {
                super.setText(s2);
            }
            catch (IOException e) {
                System.err.println("Could not set text");
            }
        }
    }

    private void setDirectText(String s2) throws IOException {
        super.setText(s2);
    }

    private void setScrollingText(final String text) {
        this.runText.set(true);
        this.scrolling = new Thread(new Runnable(){

            @Override
            public void run() {
                String txt = text + GroveRgbLcd.spacing;
                int txt_len = txt.length();
                try {
                    int i = 0;
                    while (GroveRgbLcd.this.runText.getAcquire()) {
                        int until = Math.min(i % txt_len + 32, txt_len);
                        Object lcd_txt = txt.substring(i % txt_len, until);
                        if (((String)lcd_txt).length() < 32) {
                            lcd_txt = (String)lcd_txt + txt.substring(0, 32 - ((String)lcd_txt).length());
                        }
                        GroveRgbLcd.this.setDirectText((String)lcd_txt);
                        Thread.sleep(800L);
                        i = (i + 1) % txt_len;
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        this.scrolling.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execRGB(GrovePiSequenceVoid<?> sequence) throws IOException {
        GroveRgbLcd groveRgbLcd = this;
        synchronized (groveRgbLcd) {
            sequence.execute(new IO(this.rgb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execTEXT(GrovePiSequenceVoid<?> sequence) throws IOException {
        GroveRgbLcd groveRgbLcd = this;
        synchronized (groveRgbLcd) {
            sequence.execute(new IO(this.text));
        }
    }
}

