/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.i2c.utils;

import java.security.SecureRandom;

public class LedMatrixUtils {
    public static final byte[] colors = new byte[]{18, 24, 82, 127, -86, -61, -36, -2};

    public static byte randomColor() {
        return colors[new SecureRandom(("" + System.currentTimeMillis()).getBytes()).nextInt(colors.length)];
    }

    public static byte[] encodeLetter(char c, byte color, byte bgColor) {
        byte[] encoding = new byte[64];
        int letterIndex = Character.compare(Character.toUpperCase(c), 'A');
        byte[] letter = Letter.alphabet[letterIndex];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = letter[i] == 1 ? color : bgColor;
        }
        return encoding;
    }

    public static byte[] encodeInvertedLetter(char c, byte backgroundColor) {
        return LedMatrixUtils.encodeLetter(c, (byte)-1, backgroundColor);
    }

    public static byte[] encodeLetter(char c, byte color) {
        return LedMatrixUtils.encodeLetter(c, color, (byte)-1);
    }

    public static byte[] encodeLetter(char c) {
        return LedMatrixUtils.encodeLetter(c, LedMatrixUtils.randomColor(), (byte)-1);
    }

    public static byte[] encodeInvertedLetter(char c) {
        return LedMatrixUtils.encodeLetter(c, (byte)-1, LedMatrixUtils.randomColor());
    }

    public static byte[] encodeLetterMosaic(char c) {
        byte[] encoding = new byte[64];
        int letterIndex = Character.compare(Character.toUpperCase(c), 'A');
        byte[] letter = Letter.alphabet[letterIndex];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = letter[i] == 1 ? LedMatrixUtils.randomColor() : -1;
        }
        return encoding;
    }

    public static byte[] encodeInvertedLetterMosaic(char c) {
        byte[] encoding = new byte[64];
        int letterIndex = Character.compare(Character.toUpperCase(c), 'A');
        byte[] letter = Letter.alphabet[letterIndex];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = letter[i] == 1 ? -1 : (int)LedMatrixUtils.randomColor();
        }
        return encoding;
    }

    public static byte[] encodeArrow(Arrow a, byte color, byte bgColor) {
        byte[] encoding = new byte[64];
        byte[] arrow = Icon.arrows[a.getValue()];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = arrow[i] == 1 ? color : bgColor;
        }
        return encoding;
    }

    public static byte[] encodeArrow(Arrow a, byte color) {
        return LedMatrixUtils.encodeArrow(a, color, (byte)-1);
    }

    public static byte[] encodeInvertedArrow(Arrow a, byte color) {
        byte[] encoding = new byte[64];
        byte[] arrow = Icon.arrows[a.getValue()];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = arrow[i] == 1 ? -1 : (int)color;
        }
        return encoding;
    }

    public static byte[] encodeArrow(Arrow a) {
        return LedMatrixUtils.encodeArrow(a, LedMatrixUtils.randomColor(), (byte)-1);
    }

    public static byte[] encodeInvertedArrow(Arrow a) {
        return LedMatrixUtils.encodeArrow(a, (byte)-1, LedMatrixUtils.randomColor());
    }

    public static byte[] encodeMosaicArrow(Arrow a) {
        byte[] encoding = new byte[64];
        byte[] arrow = Icon.arrows[a.getValue()];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = arrow[i] == 1 ? LedMatrixUtils.randomColor() : -1;
        }
        return encoding;
    }

    public static byte[] encodeInvertedMosaicArrow(Arrow a) {
        byte[] encoding = new byte[64];
        byte[] arrow = Icon.arrows[a.getValue()];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = arrow[i] == 1 ? -1 : (int)LedMatrixUtils.randomColor();
        }
        return encoding;
    }

    public static byte[] encodeSymbol(Symbol s2, byte c1, byte c2, byte bg) {
        byte[] encoding = new byte[64];
        byte[] symbol = Icon.symbols[s2.getValue()];
        for (int i = 0; i < 64; ++i) {
            encoding[i] = symbol[i] == 0 ? bg : (symbol[i] == 1 ? c1 : c2);
        }
        return encoding;
    }

    public static byte[] encodeWrong() {
        return LedMatrixUtils.encodeSymbol(Symbol.WRONG, (byte)0, (byte)-2, (byte)-1);
    }

    public static byte[] encodeOk() {
        return LedMatrixUtils.encodeSymbol(Symbol.OK, (byte)82, (byte)82, (byte)-1);
    }

    public static byte[] encodeForbidden() {
        return LedMatrixUtils.encodeSymbol(Symbol.FORBIDDEN, (byte)0, (byte)-2, (byte)-1);
    }

    public static byte[] encodeMandatoryFront() {
        return LedMatrixUtils.encodeSymbol(Symbol.MANDATORY_FRONT, (byte)-86, (byte)-2, (byte)-1);
    }

    public static byte[] encodeMandatoryRight() {
        return LedMatrixUtils.encodeSymbol(Symbol.MANDATORY_RIGHT, (byte)-86, (byte)-2, (byte)-1);
    }

    public static byte[] encodeMandatoryLeft() {
        return LedMatrixUtils.encodeSymbol(Symbol.MANDATORY_LEFT, (byte)-86, (byte)-2, (byte)-1);
    }

    public static byte[] encodeMandatoryBack() {
        return LedMatrixUtils.encodeSymbol(Symbol.MANDATORY_BACK, (byte)-86, (byte)-2, (byte)-1);
    }

    public class Letter {
        public static final byte[] A = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0};
        public static final byte[] B = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0};
        public static final byte[] C = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0};
        public static final byte[] D = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] E = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] F = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] G = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] H = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] I = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] J = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] K = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] L = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] M = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] N = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] O = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] P = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] Q = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        public static final byte[] R = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] S = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] T = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] U = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] V = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] W = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] X = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] Y = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] Z = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[][] alphabet = new byte[][]{A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z};

        public Letter(LedMatrixUtils this$0) {
        }
    }

    public class Icon {
        public static final byte[] ARROW_UP = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] ARROW_RIGHT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] ARROW_LEFT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] ARROW_DOWN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[][] arrows = new byte[][]{ARROW_UP, ARROW_RIGHT, ARROW_LEFT, ARROW_DOWN};
        public static final byte[] WRONG = new byte[]{1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1};
        public static final byte[] OK = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public static final byte[] FORBIDDEN = new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0};
        public static final byte[] MANDATORY_FRONT = new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 1, 1, 0, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0};
        public static final byte[] MANDATORY_RIGHT = new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 0, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0};
        public static final byte[] MANDATORY_LEFT = new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 1, 1, 1, 0, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 0, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0};
        public static final byte[] MANDATORY_BACK = new byte[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 1, 1, 0, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 0, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0};
        public static final byte[][] symbols = new byte[][]{WRONG, OK, FORBIDDEN, MANDATORY_FRONT, MANDATORY_RIGHT, MANDATORY_LEFT, MANDATORY_BACK};

        public Icon(LedMatrixUtils this$0) {
        }
    }

    public static enum Arrow {
        ARROW_UP(0),
        ARROW_RIGTH(1),
        ARROW_LEFT(2),
        ARROW_DOWN(3);

        private final int value;

        private Arrow(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Symbol {
        WRONG(0),
        OK(1),
        FORBIDDEN(2),
        MANDATORY_FRONT(3),
        MANDATORY_RIGHT(4),
        MANDATORY_LEFT(5),
        MANDATORY_BACK(6);

        private final int value;

        private Symbol(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

