/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.iot.device.serial;

import com.pi4j.context.Context;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialConfigBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class GroveGPSAir530 {
    private final Serial serial;
    private GPSData data;
    private volatile boolean running = false;
    private Thread reader;

    public GroveGPSAir530(Context pi4j) {
        SerialConfig config = (SerialConfig)((SerialConfigBuilder)Serial.newConfigBuilder(pi4j).device("/dev/serial0")).use_9600_N81().build();
        this.serial = pi4j.create(config);
        this.data = new GPSData(this);
    }

    public void start() {
        this.serial.open();
        this.running = true;
        this.reader = new Thread(this::readSerial);
        this.reader.start();
    }

    public void stop() {
        this.running = false;
        if (this.reader != null) {
            this.reader.interrupt();
        }
        this.serial.close();
    }

    private void readSerial() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.serial.getInputStream(), StandardCharsets.UTF_8));
            Object line = "";
            while (this.running && !Thread.currentThread().isInterrupted()) {
                if (this.serial.available() > 0) {
                    int ch = reader.read();
                    if (ch == 10 || ch == 13) {
                        if (!((String)line).isEmpty()) {
                            this.parseLine(((String)line).trim());
                        }
                        line = "";
                    } else if (ch != -1) {
                        line = (String)line + (char)ch;
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseLine(String line) {
        try {
            if (line.startsWith("$GNGGA") || line.startsWith("$GPGGA")) {
                this.parseGGA(line);
            } else if (line.startsWith("$GNGLL") || line.startsWith("$GPGLL")) {
                this.parseGLL(line);
            } else if (line.startsWith("$GNGSA") || line.startsWith("$GPGSA")) {
                this.parseGSA(line);
            } else if (line.startsWith("$GNGSV") || line.startsWith("$GPGSV") || line.startsWith("$BDGSV")) {
                this.parseGSV(line);
            } else if (line.startsWith("$GNRMC") || line.startsWith("$GPRMC")) {
                this.parseRMC(line);
            } else if (line.startsWith("$GNVTG") || line.startsWith("$GPVTG")) {
                this.parseVTG(line);
            } else if (line.startsWith("$GNZDA") || line.startsWith("$GPZDA")) {
                this.parseZDA(line);
            } else if (line.startsWith("$GPTXT")) {
                this.parseTXT(line);
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing line: " + line);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGGA(String line) {
        String[] fields = line.split(",");
        if (fields.length >= 15) {
            String utc = fields[1];
            String lat = fields[2];
            String latDir = fields[3];
            String lon = fields[4];
            String lonDir = fields[5];
            String quality = fields[6];
            String numSats = fields[7];
            String hdop = fields[8];
            String alt = fields[9];
            double newLat = 0.0;
            double newLon = 0.0;
            float newHdop = 0.0f;
            float newAlt = 0.0f;
            boolean validCoords = false;
            int satsUsed = 0;
            String newFix = "No Fix";
            if (!(lat.isEmpty() || lon.isEmpty() || quality.isEmpty() || quality.equals("0"))) {
                newLat = this.convertToDecimal(lat, latDir);
                newLon = this.convertToDecimal(lon, lonDir);
                validCoords = true;
                if (!numSats.isEmpty()) {
                    satsUsed = Integer.parseInt(numSats);
                }
                if (!hdop.isEmpty()) {
                    newHdop = Float.parseFloat(hdop);
                }
                if (!alt.isEmpty()) {
                    newAlt = Float.parseFloat(alt);
                }
                switch (quality) {
                    case "1": {
                        newFix = "GPS Fix";
                        break;
                    }
                    case "2": {
                        newFix = "DGPS Fix";
                        break;
                    }
                    case "3": {
                        newFix = "PPS Fix";
                        break;
                    }
                    case "4": {
                        newFix = "RTK Fix";
                        break;
                    }
                    case "5": {
                        newFix = "RTK Float";
                        break;
                    }
                    case "6": {
                        newFix = "Dead Reckoning";
                        break;
                    }
                    default: {
                        newFix = "Unknown Fix";
                    }
                }
            }
            Object object = this.data;
            synchronized (object) {
                this.data.setFixTime(utc);
                if (validCoords) {
                    this.data.setLatitude(newLat);
                    this.data.setLongitude(newLon);
                    this.data.setValidFix(true);
                    this.data.setSatellitesUsed(satsUsed);
                    this.data.setHdop(newHdop);
                    this.data.setAltitude(newAlt);
                    this.data.setFix(newFix);
                } else {
                    this.data.setValidFix(false);
                    this.data.setFix("No Fix");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGLL(String line) {
        String[] parts = line.split(",");
        if (parts.length >= 7) {
            String lat = parts[1];
            String latDir = parts[2];
            String lon = parts[3];
            String lonDir = parts[4];
            String utc = parts[5];
            String status = parts[6];
            double newLat = 0.0;
            double newLon = 0.0;
            boolean validCoords = false;
            if (status.equals("A") && !lat.isEmpty() && !lon.isEmpty()) {
                newLat = this.convertToDecimal(lat, latDir);
                newLon = this.convertToDecimal(lon, lonDir);
                validCoords = true;
            }
            GPSData gPSData = this.data;
            synchronized (gPSData) {
                this.data.setFixTime(utc);
                if (validCoords) {
                    this.data.setLatitude(newLat);
                    this.data.setLongitude(newLon);
                    this.data.setValidFix(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGSA(String line) {
        String[] fields = line.split(",");
        if (fields.length >= 18) {
            String fix = fields[2];
            String hdop = fields[16];
            int satsUsed = 0;
            for (int i = 3; i <= 14; ++i) {
                if (fields[i].isEmpty()) continue;
                ++satsUsed;
            }
            float newHdop = 0.0f;
            if (!hdop.isEmpty()) {
                newHdop = Float.parseFloat(hdop);
            }
            String newFix = "No Fix";
            switch (fix) {
                case "2": {
                    newFix = "2D Fix";
                    break;
                }
                case "3": {
                    newFix = "3D Fix";
                }
            }
            Object object = this.data;
            synchronized (object) {
                this.data.setSatellitesUsed(satsUsed);
                this.data.setHdop(newHdop);
                this.data.setFix(newFix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGSV(String line) {
        String totalSats;
        String[] parts = line.split(",");
        if (parts.length >= 4 && !(totalSats = parts[3]).isEmpty()) {
            int satCount = Integer.parseInt(totalSats);
            GPSData gPSData = this.data;
            synchronized (gPSData) {
                if (parts[0].contains("BD")) {
                    this.data.setBeidouSatellites(satCount);
                } else {
                    this.data.setVisibleSatellites(satCount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRMC(String line) {
        String[] parts = line.split(",");
        if (parts.length >= 12) {
            String utc = parts[1];
            String status = parts[2];
            String lat = parts[3];
            String latDir = parts[4];
            String lon = parts[5];
            String lonDir = parts[6];
            String speed = parts[7];
            String course = parts[8];
            String date = parts[9];
            double newLat = 0.0;
            double newLon = 0.0;
            float newSpeed = 0.0f;
            float newCourse = 0.0f;
            boolean validCoords = false;
            boolean hasSpeed = false;
            boolean hasCourse = false;
            if (status.equals("A")) {
                if (!lat.isEmpty() && !lon.isEmpty()) {
                    newLat = this.convertToDecimal(lat, latDir);
                    newLon = this.convertToDecimal(lon, lonDir);
                    validCoords = true;
                }
                if (!speed.isEmpty()) {
                    newSpeed = Float.parseFloat(speed);
                    hasSpeed = true;
                }
                if (!course.isEmpty()) {
                    newCourse = Float.parseFloat(course);
                    hasCourse = true;
                }
            }
            GPSData gPSData = this.data;
            synchronized (gPSData) {
                this.data.setFixTime(utc);
                this.data.setFixDate(date);
                if (validCoords) {
                    this.data.setLatitude(newLat);
                    this.data.setLongitude(newLon);
                    this.data.setValidFix(true);
                }
                if (hasSpeed) {
                    this.data.setSpeed(newSpeed);
                }
                if (hasCourse) {
                    this.data.setCourse(newCourse);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseVTG(String line) {
        String[] parts = line.split(",");
        if (parts.length >= 9) {
            String course = parts[1];
            String speed = parts[5];
            float newCourse = 0.0f;
            float newSpeed = 0.0f;
            boolean hasCourse = false;
            boolean hasSpeed = false;
            if (!course.isEmpty()) {
                newCourse = Float.parseFloat(course);
                hasCourse = true;
            }
            if (!speed.isEmpty()) {
                newSpeed = Float.parseFloat(speed);
                hasSpeed = true;
            }
            GPSData gPSData = this.data;
            synchronized (gPSData) {
                if (hasCourse) {
                    this.data.setCourse(newCourse);
                }
                if (hasSpeed) {
                    this.data.setSpeed(newSpeed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseZDA(String line) {
        String[] parts = line.split(",");
        if (parts.length >= 7) {
            String time = parts[1];
            String day = parts[2];
            String month = parts[3];
            String year = parts[4];
            if (!(time.isEmpty() || day.isEmpty() || month.isEmpty() || year.isEmpty())) {
                String newUtcDateTime = String.format("%s-%s-%s %s UTC", year, month, day, time);
                GPSData gPSData = this.data;
                synchronized (gPSData) {
                    this.data.setFixTime(time);
                    this.data.setUtcDateTime(newUtcDateTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTXT(String line) {
        String text;
        String[] parts = line.split(",");
        if (parts.length >= 4 && (text = parts[4]).contains("ANTENNA")) {
            GPSData gPSData = this.data;
            synchronized (gPSData) {
                this.data.setAntennaStatus(text);
            }
        }
    }

    private double convertToDecimal(String dms, String dir) {
        if (dms.isEmpty()) {
            return 0.0;
        }
        try {
            double raw = Double.parseDouble(dms);
            int degrees2 = (int)(raw / 100.0);
            double minutes = raw - (double)(degrees2 * 100);
            double decimal = (double)degrees2 + minutes / 60.0;
            if ("S".equals(dir) || "W".equals(dir)) {
                decimal = -decimal;
            }
            return decimal;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public GPSData getGPSData() {
        return this.data;
    }

    public class GPSData {
        private volatile double latitude = 0.0;
        private volatile double longitude = 0.0;
        private volatile boolean validFix = false;
        private volatile float speed = 0.0f;
        private volatile float course = 0.0f;
        private volatile float altitude = 0.0f;
        private volatile int satellitesUsed = 0;
        private volatile int visibleSatellites = 0;
        private volatile int beidouSatellites = 0;
        private volatile float hdop = 0.0f;
        private volatile String fixTime = "";
        private volatile String fixDate = "";
        private volatile String fixType = "No Fix";
        private volatile String antennaStatus = "";
        private volatile String utcDateTime = "";

        GPSData(GroveGPSAir530 this$0) {
        }

        private void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        private void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        private void setValidFix(boolean validFix) {
            this.validFix = validFix;
        }

        private void setSpeed(float speed) {
            this.speed = speed;
        }

        private void setCourse(float course) {
            this.course = course;
        }

        private void setAltitude(float altitude) {
            this.altitude = altitude;
        }

        private void setSatellitesUsed(int satellitesUsed) {
            this.satellitesUsed = satellitesUsed;
        }

        private void setVisibleSatellites(int visibleSatellites) {
            this.visibleSatellites = visibleSatellites;
        }

        private void setBeidouSatellites(int beidouSatellites) {
            this.beidouSatellites = beidouSatellites;
        }

        private void setHdop(float hdop) {
            this.hdop = hdop;
        }

        private void setFixTime(String fixTime) {
            this.fixTime = fixTime;
        }

        private void setFixDate(String fixDate) {
            this.fixDate = fixDate;
        }

        private void setFix(String fixType) {
            this.fixType = fixType;
        }

        private void setAntennaStatus(String antennaStatus) {
            this.antennaStatus = antennaStatus;
        }

        private void setUtcDateTime(String utcDateTime) {
            this.utcDateTime = utcDateTime;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public boolean hasValidFix() {
            return this.validFix;
        }

        public float getSpeed() {
            return this.speed;
        }

        public float getCourse() {
            return this.course;
        }

        public float getAltitude() {
            return this.altitude;
        }

        public int getSatellitesUsed() {
            return this.satellitesUsed;
        }

        public int getVisibleSatellites() {
            return this.visibleSatellites;
        }

        public int getBeidouSatellites() {
            return this.beidouSatellites;
        }

        public float getHDOP() {
            return this.hdop;
        }

        public String getFixTime() {
            return this.fixTime;
        }

        public String getFixDate() {
            return this.fixDate;
        }

        public String getFixType() {
            return this.fixType;
        }

        public String getAntennaStatus() {
            return this.antennaStatus;
        }

        public String getUtcDateTime() {
            return this.utcDateTime;
        }

        public String toString() {
            return String.format("Fix: %s | Lat: %.6f | Lon: %.6f | Speed: %.1f knots | Course: %.1f\u00b0 | Altitude: %.1fm | Satellites: %d/%d | BeiDou: %d | HDOP: %.1f | Time: %s | Antenna Status: %s", this.fixType, this.latitude, this.longitude, Float.valueOf(this.speed), Float.valueOf(this.course), Float.valueOf(this.altitude), this.satellitesUsed, this.visibleSatellites, this.beidouSatellites, Float.valueOf(this.hdop), this.utcDateTime.isEmpty() ? this.fixTime : this.utcDateTime, this.antennaStatus);
        }
    }
}

