/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network;

import java.util.List;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;

public interface AttributeValidator {
    public static final String CHANNEL_MAGIC_ATTRIBUTE = "magic_number";
    public static final AttributeValidator ALWAYS_VALID = attr -> true;

    public boolean validateAttributes(Attributes var1);

    default public Attributes getSecondHandshakeAttributes(long connectionId, Attributes peerAttrs, Attributes myBaseAttrs) throws InvalidHandshakeException {
        if (this.validateAttributes(peerAttrs)) {
            return myBaseAttrs;
        }
        throw new InvalidHandshakeAttributesException(peerAttrs, "Invalid first handshake attributes.");
    }

    default public Attributes getNthHandshakeAttributes(long connectionId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeException {
        if (this.validateAttributes(peerAttrs.getLast())) {
            return mySentAttrs.getLast();
        }
        throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1);
    }
}

