/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.List;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;
import pt.unl.fct.di.novasys.network.messaging.control.FirstHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.InvalidAttributesMessage;
import pt.unl.fct.di.novasys.network.messaging.control.NthHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.SecondHandshakeMessage;
import pt.unl.fct.di.novasys.network.userevents.HandshakeCompleted;

public class InHandshakeHandler
extends ChannelDuplexHandler {
    public static final String NAME = "InHandshakeHandler";
    protected final AttributeValidator validator;
    protected final long connectionId;
    protected final List<Attributes> peerAttrs;
    protected final List<Attributes> myAttrs;
    protected final Attributes baseAttrs;
    protected final int handshakeSteps;

    public InHandshakeHandler(long connectionId, AttributeValidator validator, Attributes baseAttrs, int handshakeSteps) {
        this.connectionId = connectionId;
        this.validator = validator;
        this.myAttrs = new ArrayList<Attributes>(handshakeSteps / 2);
        this.peerAttrs = new ArrayList<Attributes>((handshakeSteps + 1) / 2);
        this.baseAttrs = baseAttrs;
        this.handshakeSteps = handshakeSteps;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE));
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        NetworkMessage msg = (NetworkMessage)obj;
        if (msg.code != 0) {
            throw new Exception("Received application message in inHandshake: " + String.valueOf(msg));
        }
        try {
            ControlMessage cMsg = (ControlMessage)msg.payload;
            switch (cMsg.type) {
                case HEARTBEAT: {
                    return;
                }
                case FIRST_HS: {
                    this.handleFirstHandshakeMessage(ctx, (FirstHandshakeMessage)cMsg);
                    break;
                }
                case NTH_HS: {
                    this.handleNthHandshakeMessage(ctx, (NthHandshakeMessage)cMsg);
                    break;
                }
                case INVALID_ATTR: {
                    throw new Exception("Attributes refused from in connection with " + String.valueOf(ctx.channel().remoteAddress()));
                }
                default: {
                    throw new Exception("Received unexpected control message in inHandshake: " + String.valueOf(msg));
                }
            }
        }
        catch (InvalidHandshakeException e) {
            ctx.channel().writeAndFlush(new NetworkMessage(0, new InvalidAttributesMessage()));
            throw e;
        }
    }

    protected void handleFirstHandshakeMessage(ChannelHandlerContext ctx, FirstHandshakeMessage fhm) throws InvalidHandshakeException {
        Attributes replyAttrs = this.validator.getSecondHandshakeAttributes(this.connectionId, fhm.attributes, this.baseAttrs);
        this.peerAttrs.add(fhm.attributes);
        this.myAttrs.add(replyAttrs);
        ctx.channel().writeAndFlush(new NetworkMessage(0, new SecondHandshakeMessage(replyAttrs)));
        if (this.handshakeSteps <= 2) {
            ctx.fireUserEventTriggered(new HandshakeCompleted(fhm.attributes));
            ctx.pipeline().remove(this);
        }
    }

    protected void handleNthHandshakeMessage(ChannelHandlerContext ctx, NthHandshakeMessage nhm) throws InvalidHandshakeException {
        if (nhm.handshakeStep / 2 != this.peerAttrs.size()) {
            throw new InvalidHandshakeException("Invalid NthHandshakeMessage step for InHandshakeHandler: " + nhm.handshakeStep);
        }
        this.peerAttrs.add(nhm.attributes);
        int nextStep = nhm.handshakeStep + 1;
        Attributes replyAttrs = this.validator.getNthHandshakeAttributes(this.connectionId, nextStep, this.peerAttrs, this.myAttrs);
        if (nextStep <= this.handshakeSteps) {
            this.myAttrs.add(replyAttrs);
            ctx.channel().writeAndFlush(new NetworkMessage(0, new NthHandshakeMessage(replyAttrs, nextStep)));
        } else {
            Attributes finalPeerAttributes = new Attributes();
            for (Attributes attr : this.peerAttrs) {
                finalPeerAttributes.putAll(attr);
            }
            ctx.fireUserEventTriggered(new HandshakeCompleted(finalPeerAttributes));
            ctx.pipeline().remove(this);
        }
    }
}

