/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class MessageDecoder<T>
extends ByteToMessageDecoder {
    public static final String NAME = "MessageDecoder";
    private final ISerializer<T> serializer;
    private long receivedAppBytes;
    private long receivedControlBytes;
    private long receivedAppMessages;
    private long receivedControlMessages;

    public MessageDecoder(ISerializer<T> serializer) {
        this.serializer = serializer;
        this.receivedAppBytes = 0L;
        this.receivedAppMessages = 0L;
        this.receivedControlBytes = 0L;
        this.receivedControlMessages = 0L;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException {
        ControlMessage payload;
        if (in.readableBytes() < 4) {
            return;
        }
        int msgSize = in.getInt(in.readerIndex());
        if (in.readableBytes() < msgSize + 4) {
            return;
        }
        in.skipBytes(4);
        int startIndex = in.readerIndex();
        ByteBuf slice = in.slice(startIndex, msgSize);
        byte code = slice.readByte();
        switch (code) {
            case 0: {
                payload = ControlMessage.serializer.deserialize(slice);
                ++this.receivedControlMessages;
                this.receivedControlBytes += (long)(4 + msgSize);
                break;
            }
            case 1: {
                payload = this.serializer.deserialize(slice);
                this.receivedAppBytes += (long)(4 + msgSize);
                ++this.receivedAppMessages;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown msg code in decoder: " + code));
            }
        }
        out.add(new NetworkMessage(code, payload));
        in.skipBytes(msgSize);
    }

    public long getReceivedAppBytes() {
        return this.receivedAppBytes;
    }

    public long getReceivedAppMessages() {
        return this.receivedAppMessages;
    }

    public long getReceivedControlBytes() {
        return this.receivedControlBytes;
    }

    public long getReceivedControlMessages() {
        return this.receivedControlMessages;
    }
}

