/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;

class X509SubKeyManager
extends X509IKeyManager {
    final X509IKeyManager man;
    final Set<String> validAliases;
    final Set<Bytes> validIds;

    X509SubKeyManager(X509IKeyManager wrappedManager, Collection<String> aliases, Collection<byte[]> ids) {
        this.man = wrappedManager;
        this.validAliases = new HashSet<String>(aliases);
        this.validIds = ids.stream().map(Bytes::of).collect(Collectors.toSet());
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return (String[])Arrays.stream(this.man.getClientAliases(keyType, issuers)).filter(this.validAliases::contains).toArray(String[]::new);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String alias = this.man.chooseClientAlias(keyType, issuers, socket);
        if (!this.validAliases.contains(alias)) {
            alias = this.validAliases.stream().findAny().orElse(null);
        }
        return alias;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return (String[])Arrays.stream(this.man.getServerAliases(keyType, issuers)).filter(this.validAliases::contains).toArray(String[]::new);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = this.man.chooseServerAlias(keyType, issuers, socket);
        if (!this.validAliases.contains(alias)) {
            alias = this.validAliases.stream().findAny().orElse(null);
        }
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.validAliases.contains(alias) ? this.man.getCertificateChain(alias) : null;
    }

    @Override
    public X509Certificate[] getCertificateChain(byte[] id) {
        return this.validIds.contains(Bytes.of(id)) ? this.man.getCertificateChain(id) : null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.validAliases.contains(alias) ? this.man.getPrivateKey(alias) : null;
    }

    @Override
    public PrivateKey getPrivateKey(byte[] id) {
        return this.validIds.contains(Bytes.of(id)) ? this.man.getPrivateKey(id) : null;
    }

    @Override
    public String getIdAlias(byte[] id) {
        return this.validIds.contains(Bytes.of(id)) ? this.man.getIdAlias(id) : null;
    }

    @Override
    public byte[] getAliasId(String alias) {
        return this.validAliases.contains(alias) ? this.man.getAliasId(alias) : null;
    }
}

