/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.tls.pipeline;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.FirstHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.NthHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.SecondHandshakeMessage;
import pt.unl.fct.di.novasys.network.pipeline.OutHandshakeHandler;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.tls.userevents.PreTLSHandshakeCompleted;

public class OutPreTLSHandshakeHandler
extends OutHandshakeHandler {
    private static final Logger logger = LogManager.getLogger(OutPreTLSHandshakeHandler.class);
    private final X509IKeyManager identityChooser;
    private byte[] chosenId;
    private Optional<byte[]> expectedId;
    public static final String ID_ATTR = "identity";
    public static final String EXPECTED_ID_ATTR = "expected_identity";

    public OutPreTLSHandshakeHandler(long connectionId, AttributeValidator validator, Attributes myAttrs, int handshakeSteps, X509IKeyManager identityChooser) {
        super(connectionId, validator, myAttrs, handshakeSteps);
        this.identityChooser = identityChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        logger.trace("Starting out handshake...");
        Attributes firstHsAttrs = ((Attributes)this.myAttrs.getFirst()).shallowClone();
        this.expectedId = Optional.ofNullable(firstHsAttrs.getBytes(EXPECTED_ID_ATTR));
        X509IKeyManager x509IKeyManager = this.identityChooser;
        synchronized (x509IKeyManager) {
            String myAlias = this.identityChooser.chooseClientAlias(new String[0], null, null);
            this.chosenId = this.identityChooser.getAliasId(myAlias);
        }
        firstHsAttrs.putBytes(ID_ATTR, this.chosenId);
        ctx.channel().writeAndFlush(new NetworkMessage(0, new FirstHandshakeMessage(firstHsAttrs)));
        ctx.fireChannelActive();
    }

    @Override
    protected void handleSecondHandshakeMessage(ChannelHandlerContext ctx, SecondHandshakeMessage shm) throws InvalidHandshakeException {
        this.peerAttrs.add(shm.attributes);
        int nextStep = 3;
        Attributes replyAttrs = this.validator.getNthHandshakeAttributes(this.connectionId, nextStep, this.peerAttrs, this.myAttrs);
        if (this.handshakeSteps > 2) {
            throw new UnsupportedOperationException("TODO");
        }
        if (this.handshakeSteps == 2 || this.handshakeSteps == 3) {
            ctx.fireUserEventTriggered(this.handshakeCompletedEvent(shm.attributes));
            ctx.pipeline().remove(this);
        }
    }

    private PreTLSHandshakeCompleted handshakeCompletedEvent(Attributes peerAttrs) throws InvalidHandshakeAttributesException {
        byte[] peerId = peerAttrs.getBytes(ID_ATTR);
        if (peerId == null || this.expectedId.map(expected -> !Arrays.equals(peerId, expected)).orElse(false).booleanValue()) {
            throw new InvalidHandshakeAttributesException(peerAttrs, "Given identity %s did not match the expected %s".formatted(Bytes.of(peerId), Bytes.of(this.expectedId.orElse(null))));
        }
        return new PreTLSHandshakeCompleted(peerAttrs, this.chosenId, peerId);
    }

    @Override
    protected void handleNthHandshakeMessage(ChannelHandlerContext ctx, NthHandshakeMessage nhm) throws InvalidHandshakeException {
        throw new UnsupportedOperationException("TODO");
    }
}

