/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.api;

import java.util.Comparator;
import java.util.Objects;
import java.util.Set;

public class Threshold<T> {
    private final ThresholdType type;
    private final T singleValue;
    private final T lowerBound;
    private final T upperBound;
    private final Set<T> multipleValues;
    private final Comparator<T> comparator;

    public static <T> Threshold<T> none() {
        return new Threshold<Object>(ThresholdType.NONE, null, null, null, null, null);
    }

    public static <T> Threshold<T> equalTo(T value, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.EQUAL, value, null, null, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> equalTo(T value) {
        return new Threshold<Object>(ThresholdType.EQUAL, value, null, null, (Set<Object>)null, (Comparator<Object>)null);
    }

    public static <T> Threshold<T> notEqualTo(T value, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.NOT_EQUAL, value, null, null, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> notEqualTo(T value) {
        return new Threshold<Object>(ThresholdType.NOT_EQUAL, value, null, null, (Set<Object>)null, (Comparator<Object>)null);
    }

    public static <T> Threshold<T> lessThan(T value, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.LESS_THAN, value, null, null, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> greaterThan(T value, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.GREATER_THAN, value, null, null, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> inRange(T lowerBound, T upperBound, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.IN_RANGE, null, lowerBound, upperBound, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> outsideRange(T lowerBound, T upperBound, Comparator<T> comparator) {
        return new Threshold<Object>(ThresholdType.OUTSIDE_RANGE, null, lowerBound, upperBound, (Set<Object>)null, (Comparator<Object>)comparator);
    }

    public static <T> Threshold<T> any(Set<T> values) {
        return new Threshold<Object>(ThresholdType.ANY, null, null, null, values, null);
    }

    private Threshold(ThresholdType type, T singleValue, T lowerBound, T upperBound, Set<T> multipleValues, Comparator<T> comparator) {
        this.type = type;
        this.singleValue = singleValue;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.multipleValues = multipleValues;
        this.comparator = comparator;
    }

    public boolean test(T value) {
        if (value == null) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.comparator == null ? Objects.equals(value, this.singleValue) : this.comparator.compare(value, this.singleValue) == 0;
            }
            case 2: {
                return this.comparator == null ? !Objects.equals(value, this.singleValue) : this.comparator.compare(value, this.singleValue) != 0;
            }
            case 3: {
                if (this.comparator == null) {
                    throw new IllegalArgumentException("LESS_THAN comparisons require a comparator");
                }
                return this.comparator.compare(value, this.singleValue) < 0;
            }
            case 4: {
                if (this.comparator == null) {
                    throw new IllegalArgumentException("GREATER_THAN comparisons require a comparator");
                }
                return this.comparator.compare(value, this.singleValue) > 0;
            }
            case 5: {
                if (this.comparator == null) {
                    throw new IllegalArgumentException("Range comparisons require a comparator");
                }
                return this.comparator.compare(value, this.lowerBound) >= 0 && this.comparator.compare(value, this.upperBound) <= 0;
            }
            case 6: {
                if (this.comparator == null) {
                    throw new IllegalArgumentException("Range comparisons require a comparator");
                }
                return this.comparator.compare(value, this.lowerBound) >= 0 && this.comparator.compare(value, this.upperBound) <= 0;
            }
            case 7: {
                return this.multipleValues.contains(value);
            }
        }
        return false;
    }

    private static enum ThresholdType {
        NONE,
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        GREATER_THAN,
        IN_RANGE,
        OUTSIDE_RANGE,
        ANY;

    }
}

