/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.exception.Pi4JException;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInputProvider;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutputProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.iot.device.Device;
import pt.unl.fct.di.novasys.iot.device.digital.GroveEncoder;
import pt.unl.fct.di.novasys.iot.device.digital.GroveUltrasonicRanger;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceInterface;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.ErrorCode;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTPeriodicEventRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTReactiveEventRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners.EncoderListener;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners.IoTMonitoringService;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.notifications.EncoderNotification;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.replies.EncoderInputReply;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.replies.UltrasonicRangerInputReply;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.input.GetReactiveEncoderRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.input.GetUltrasonicRangerMeasurementRequest;

public class DigitalInputControlProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "DigitalInputControlProtocol";
    public static final short PROTOCOL_ID = 4002;
    private static final Logger logger = LogManager.getLogger(DigitalInputControlProtocol.class);
    private final Context pi4j;
    private GroveUltrasonicRanger ranger;
    private GroveEncoder encoder;
    private final IoTMonitoringService monitor;
    private final AtomicInteger ids;
    private final HashMap<Device, Short> deviceIds;
    private final HashMap<Short, Device> deviceIdsMapping;
    private final HashMap<DeviceHandle, Device> deviceMappings;
    private final HashMap<Device, Set<DeviceHandle>> deviceHandles;

    public DigitalInputControlProtocol() {
        super(PROTOCOL_NAME, (short)4002);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new RaspberryPiPlatform(this){

            @Override
            protected String[] getProviders() {
                return new String[0];
            }
        }).add(PiGpioDigitalInputProvider.newInstance(piGpio), PiGpioDigitalOutputProvider.newInstance(piGpio), PiGpioPwmProvider.newInstance(piGpio), PiGpioSerialProvider.newInstance(piGpio), PiGpioSpiProvider.newInstance(piGpio), GpioDDigitalInputProvider.newInstance(), GpioDDigitalOutputProvider.newInstance(), LinuxFsI2CProvider.newInstance()).build();
        this.monitor = IoTMonitoringService.getInstance();
        this.ids = new AtomicInteger(0);
        this.deviceIds = new HashMap();
        this.deviceIdsMapping = new HashMap();
        this.deviceMappings = new HashMap();
        this.deviceHandles = new HashMap();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.registerRequestHandler((short)4000, this::handleRegisterIoTDeviceRequest);
        this.registerRequestHandler((short)4001, this::handleUnregisterIoTDeviceRequest);
        this.registerRequestHandler((short)8015, this::handleReactiveEncoderInputRequest);
    }

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req, short protocolId) {
        if (!req.getDeviceType().getDeviceInterface().equals((Object)DeviceInterface.DIGITAL_IN)) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.INVALID_INTERFACE, "Device interface is invalid, this protocol operates on Digital input devices"), protocolId);
            return;
        }
        switch (req.getDeviceType()) {
            case GROVE_ULTRASONIC_RANGER: {
                this.registerUltrasonicRanger(req, protocolId);
                break;
            }
            case GROVE_ENCODER: {
                this.registerEncoder(req, protocolId);
                break;
            }
            default: {
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.UNKNOWN_DEVICE, "Unknown DeviceType"), protocolId);
            }
        }
    }

    private void registerUltrasonicRanger(RegisterIoTDeviceRequest req, short protocolId) {
        if (this.ranger == null) {
            try {
                this.ranger = new GroveUltrasonicRanger(this.pi4j, req.getDeviceAlias(), req.getLine(), (int)req.getId());
            }
            catch (Pi4JException pe) {
                logger.error("Could not initialize the Ultrasonic Ranger: ", (Throwable)pe);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                this.ranger = null;
            }
            if (this.ranger == null) {
                return;
            }
            short id = (short)this.ids.incrementAndGet();
            this.deviceIds.put(this.ranger, id);
            this.deviceIdsMapping.put(id, this.ranger);
        }
        if (this.ranger == null) {
            return;
        }
        DeviceHandle handle = new DeviceHandle(DeviceType.GROVE_ULTRASONIC_RANGER, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.ranger), req.getDeviceAlias());
        this.deviceMappings.put(handle, this.ranger);
        if (!this.deviceHandles.containsKey(this.ranger)) {
            this.deviceHandles.put(this.ranger, new HashSet());
        }
        this.deviceHandles.get(this.ranger).add(handle);
        this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
    }

    private void registerEncoder(RegisterIoTDeviceRequest req, short protocolId) {
        if (this.encoder == null) {
            try {
                this.encoder = new GroveEncoder(this.pi4j, req.getDeviceAlias(), req.getLine(), (int)req.getId());
            }
            catch (Pi4JException pe) {
                logger.error("Could not initialize the Ultrasonic Ranger: ", (Throwable)pe);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                this.encoder = null;
            }
            if (this.encoder == null) {
                return;
            }
            short id = (short)this.ids.incrementAndGet();
            this.deviceIds.put(this.encoder, id);
            this.deviceIdsMapping.put(id, this.encoder);
        }
        if (this.encoder == null) {
            return;
        }
        DeviceHandle handle = new DeviceHandle(DeviceType.GROVE_ENCODER, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.encoder), req.getDeviceAlias());
        this.deviceMappings.put(handle, this.encoder);
        if (!this.deviceHandles.containsKey(this.encoder)) {
            this.deviceHandles.put(this.encoder, new HashSet());
        }
        this.deviceHandles.get(this.encoder).add(handle);
        this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
    }

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req, short protocolId) {
    }

    public void handleReactiveEncoderInputRequest(GetReactiveEncoderRequest req, short protocolId) {
        logger.debug("Received a GetReactiveGestureRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (!(d instanceof GroveEncoder) || this.encoder == null) {
            this.sendReply(new EncoderInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "GroveEncoder is not available to deteect activity"), protocolId);
            return;
        }
        EncoderListener el = new EncoderListener(this.encoder, req.getThreshold(), detectedRotation -> this.triggerNotification(new EncoderNotification(h2, (GroveEncoder.Rotation)((Object)detectedRotation))));
        this.monitor.registerIoTListener(el);
    }

    public void handleRangerMeasurmentRequest(GetUltrasonicRangerMeasurementRequest req, short protocolId) {
        logger.debug("Received an GetUltrasonicRangerMeasurementRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveUltrasonicRanger && this.ranger != null) {
            switch (req.getInputType()) {
                case CENTIMETERS: {
                    this.sendReply(new UltrasonicRangerInputReply(h2, req.getInputType(), this.ranger.measureInCentimeters()), protocolId);
                    break;
                }
                case MILLIMETERS: {
                    this.sendReply(new UltrasonicRangerInputReply(h2, req.getInputType(), this.ranger.measureInMillimeters()), protocolId);
                    break;
                }
                case INCHES: {
                    this.sendReply(new UltrasonicRangerInputReply(h2, req.getInputType(), this.ranger.measureInInches()), protocolId);
                    break;
                }
                default: {
                    this.sendReply(new UltrasonicRangerInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.FAILED_MEASUREMENT, "Unsupported measurement on GroveUltrasonicRanger"), protocolId);
                    break;
                }
            }
        } else {
            this.sendReply(new UltrasonicRangerInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "GroveUltrasonicRanger is not available to take measurements"), protocolId);
        }
    }

    public void handleIoTPeriodicInputRequest(IoTPeriodicEventRequest req, short protocolId) {
    }

    public void handleIoTReactiveInputRequest(IoTReactiveEventRequest<?> req, short protocolId) {
    }
}

