/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInputProvider;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutputProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.iot.device.Device;
import pt.unl.fct.di.novasys.iot.device.digital.GroveChainableRGB;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceInterface;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.ErrorCode;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetChainableLEDColorHSBRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetChainableLEDColorRGBRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetMultipleChainableLEDColorHSBRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetMultipleChainableLEDColorRGBRequest;

public class DigitalOutputControlProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "DigitalOutputControlProtocol";
    public static final short PROTOCOL_ID = 4003;
    public static final String RGB_LED_COUNT = "rgb.led.count";
    private static final Logger logger = LogManager.getLogger(DigitalOutputControlProtocol.class);
    private final Context pi4j;
    private GroveChainableRGB rgb;
    private short numLeds;
    private final AtomicInteger ids;
    private final HashMap<Device, Short> deviceIds;
    private final HashMap<Short, Device> deviceIdsMapping;
    private final HashMap<DeviceHandle, Device> deviceMappings;
    private final HashMap<Device, Set<DeviceHandle>> deviceHandles;

    public DigitalOutputControlProtocol() {
        super(PROTOCOL_NAME, (short)4003);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new RaspberryPiPlatform(this){

            @Override
            protected String[] getProviders() {
                return new String[0];
            }
        }).add(PiGpioDigitalInputProvider.newInstance(piGpio), PiGpioDigitalOutputProvider.newInstance(piGpio), PiGpioPwmProvider.newInstance(piGpio), PiGpioSerialProvider.newInstance(piGpio), PiGpioSpiProvider.newInstance(piGpio), GpioDDigitalInputProvider.newInstance(), GpioDDigitalOutputProvider.newInstance(), LinuxFsI2CProvider.newInstance()).build();
        this.ids = new AtomicInteger(0);
        this.deviceIds = new HashMap();
        this.deviceIdsMapping = new HashMap();
        this.deviceMappings = new HashMap();
        this.deviceHandles = new HashMap();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (props.containsKey(RGB_LED_COUNT)) {
            this.numLeds = Short.parseShort(props.getProperty(RGB_LED_COUNT));
        } else {
            this.numLeds = 1;
            logger.debug("Assuming 1 Chainable RGB LED is attached.\nConfigurable via .props file with rgb.led.count");
        }
        this.registerRequestHandler((short)4000, this::handleRegisterIoTDeviceRequest);
        this.registerRequestHandler((short)4001, this::handleUnregisterIoTDeviceRequest);
        this.registerRequestHandler((short)8023, this::handleChainableLEDColorRGBRequest);
        this.registerRequestHandler((short)8022, this::handleChainableLEDColorHSBRequest);
        this.registerRequestHandler((short)8026, this::handleMultipleChainableLEDColorRGBRequest);
        this.registerRequestHandler((short)8025, this::handleMultipleChainableLEDColorHSBRequest);
    }

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req, short protocolId) {
        if (!req.getDeviceType().getDeviceInterface().equals((Object)DeviceInterface.DIGITAL_OUT)) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.INVALID_INTERFACE, "Device interface is invalid, this protocol operates on Digital input devices"), protocolId);
            return;
        }
        DeviceHandle handle = null;
        switch (req.getDeviceType()) {
            case GROVE_CHAINABLE_RGB: {
                if (this.rgb == null) {
                    try {
                        this.rgb = new GroveChainableRGB(this.pi4j, req.getDeviceAlias(), req.getLine(), req.getId(), (int)this.numLeds);
                    }
                    catch (Exception pe) {
                        logger.error("Could not initialize the Chainable RGB LEDs: ", (Throwable)pe);
                        this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                        this.rgb = null;
                    }
                    if (this.rgb == null) {
                        return;
                    }
                    short id = (short)this.ids.incrementAndGet();
                    this.deviceIds.put(this.rgb, id);
                    this.deviceIdsMapping.put(id, this.rgb);
                }
                if (this.rgb == null) {
                    return;
                }
                handle = new DeviceHandle(DeviceType.GROVE_CHAINABLE_RGB, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.rgb), req.getDeviceAlias());
                this.deviceMappings.put(handle, this.rgb);
                if (!this.deviceHandles.containsKey(this.rgb)) {
                    this.deviceHandles.put(this.rgb, new HashSet());
                }
                this.deviceHandles.get(this.rgb).add(handle);
                this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
                break;
            }
            default: {
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.UNKNOWN_DEVICE, "Unknown DeviceType"), protocolId);
            }
        }
    }

    public void handleChainableLEDColorRGBRequest(SetChainableLEDColorRGBRequest req, short protocolId) {
        logger.debug("Received a SetChainableLEDColorRGBRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveChainableRGB && this.rgb != null) {
            this.rgb.setColorRGB(req.getIdx(), req.getRed(), req.getGreen(), req.getBlue());
        }
    }

    public void handleChainableLEDColorHSBRequest(SetChainableLEDColorHSBRequest req, short protocolId) {
        logger.debug("Received a SetChainableLEDColorHSBRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveChainableRGB && this.rgb != null) {
            this.rgb.setColorHSB(req.getIdx(), req.getHue(), req.getSaturation(), req.getBrightness());
        }
    }

    public void handleMultipleChainableLEDColorRGBRequest(SetMultipleChainableLEDColorRGBRequest req, short protocolId) {
        logger.debug("Received a SetChainableLEDColorRGBRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveChainableRGB && this.rgb != null) {
            Iterator<Byte> ite = req.getPositionsIterator();
            while (ite.hasNext()) {
                byte pos = ite.next();
                this.rgb.setColorRGB(pos, req.getPositionRed(pos), req.getPositionGreen(pos), req.getPositionBlue(pos));
            }
        }
    }

    public void handleMultipleChainableLEDColorHSBRequest(SetMultipleChainableLEDColorHSBRequest req, short protocolId) {
        logger.debug("Received a SetChainableLEDColorHSBRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveChainableRGB && this.rgb != null) {
            Iterator<Byte> ite = req.getPositionsIterator();
            while (ite.hasNext()) {
                byte pos = ite.next();
                this.rgb.setColorHSB(pos, req.getPositionHue(pos), req.getPositionSaturation(pos), req.getPositionBrightness(pos));
            }
        }
    }

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req, short protocolId) {
    }
}

