/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInputProvider;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutputProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.iot.device.Device;
import pt.unl.fct.di.novasys.iot.device.i2c.Grove3AxisAccelerometer;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveBarometer;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveGestureDetector;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceInterface;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.ErrorCode;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTPeriodicEventRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners.GestureListener;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners.IoTMonitoringService;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.notifications.GestureNotification;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.replies.AccelerometerInputReply;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.replies.GestureInputReply;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.input.GetAccelerometerDataRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.input.GetGestureRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.input.GetReactiveGestureRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.utils.I2CScanner;

public class I2CInputControlProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "I2CInputControlProtocol";
    public static final short PROTOCOL_ID = 4001;
    private static final Logger logger = LogManager.getLogger(I2CInputControlProtocol.class);
    private final Context pi4j;
    private Grove3AxisAccelerometer accelerometer;
    private GroveGestureDetector gesture;
    private GroveBarometer barometer;
    private final I2CScanner scanner;
    private final IoTMonitoringService monitor;
    private final AtomicInteger ids;
    private final HashMap<Device, Short> deviceIds;
    private final HashMap<Short, Device> deviceIdsMapping;
    private final HashMap<DeviceHandle, Device> deviceMappings;
    private final HashMap<Device, Set<DeviceHandle>> deviceHandles;

    public I2CInputControlProtocol() {
        super(PROTOCOL_NAME, (short)4001);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new RaspberryPiPlatform(this){

            @Override
            protected String[] getProviders() {
                return new String[0];
            }
        }).add(PiGpioDigitalInputProvider.newInstance(piGpio), PiGpioDigitalOutputProvider.newInstance(piGpio), PiGpioPwmProvider.newInstance(piGpio), PiGpioSerialProvider.newInstance(piGpio), PiGpioSpiProvider.newInstance(piGpio), GpioDDigitalInputProvider.newInstance(), GpioDDigitalOutputProvider.newInstance(), LinuxFsI2CProvider.newInstance()).build();
        this.scanner = I2CScanner.getInstance();
        this.monitor = IoTMonitoringService.getInstance();
        this.ids = new AtomicInteger(0);
        this.deviceIds = new HashMap();
        this.deviceIdsMapping = new HashMap();
        this.deviceMappings = new HashMap();
        this.deviceHandles = new HashMap();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.registerRequestHandler((short)4000, this::handleRegisterIoTDeviceRequest);
        this.registerRequestHandler((short)4001, this::handleUnregisterIoTDeviceRequest);
        this.registerRequestHandler((short)8014, this::handleGestureInputRequest);
        this.registerRequestHandler((short)8011, this::handleAccelerometerInputRequest);
        this.registerRequestHandler((short)8016, this::handleReactiveGestureInputRequest);
    }

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req, short protocolId) {
        if (!req.getDeviceType().getDeviceInterface().equals((Object)DeviceInterface.I2C_IN)) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.INVALID_INTERFACE, "Device interface is invalid, this protocol operates on I2C input devices"), protocolId);
            return;
        }
        Set<DeviceType> devices = this.scanner.getConnectedDevices();
        if (!devices.contains((Object)req.getDeviceType())) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "Device is not connected"), protocolId);
            return;
        }
        switch (req.getDeviceType()) {
            case GROVE_GESTURE_DETECTOR: {
                this.registerGestureDetector(req, protocolId);
                break;
            }
            case GROVE_3AXIS_ACCELEROMETER: {
                this.registerAccelerometer(req, protocolId);
                break;
            }
            case GROVE_BAROMETER: {
                this.registerBarometer(req, protocolId);
                break;
            }
            default: {
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.UNKNOWN_DEVICE, "Unknown DeviceType"), protocolId);
            }
        }
    }

    private void registerGestureDetector(RegisterIoTDeviceRequest req, short protocolId) {
        if (this.gesture == null) {
            try {
                this.gesture = new GroveGestureDetector(this.pi4j);
            }
            catch (IOException e) {
                logger.error("Could not initialize the Gesture Detector: ", (Throwable)e);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                this.gesture = null;
            }
            catch (Exception pe) {
                logger.error("Could not initialize the Gesture Detector: ", (Throwable)pe);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                this.gesture = null;
            }
            if (this.gesture == null) {
                return;
            }
            short id = (short)this.ids.incrementAndGet();
            this.deviceIds.put(this.gesture, id);
            this.deviceIdsMapping.put(id, this.gesture);
        }
        if (this.gesture == null) {
            return;
        }
        DeviceHandle handle = new DeviceHandle(DeviceType.GROVE_GESTURE_DETECTOR, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.gesture), req.getDeviceAlias());
        this.deviceMappings.put(handle, this.gesture);
        if (!this.deviceHandles.containsKey(this.gesture)) {
            this.deviceHandles.put(this.gesture, new HashSet());
        }
        this.deviceHandles.get(this.gesture).add(handle);
        this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
    }

    private void registerAccelerometer(RegisterIoTDeviceRequest req, short protocolId) {
        if (this.accelerometer == null) {
            try {
                this.accelerometer = new Grove3AxisAccelerometer(this.pi4j);
            }
            catch (IOException e) {
                logger.error("Could not initialize the Accelerometer: ", (Throwable)e);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                this.accelerometer = null;
            }
            catch (Exception pe) {
                logger.error("Could not initialize the Accelerometer: ", (Throwable)pe);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                this.accelerometer = null;
            }
            if (this.accelerometer == null) {
                return;
            }
            short id = (short)this.ids.incrementAndGet();
            this.deviceIds.put(this.accelerometer, id);
            this.deviceIdsMapping.put(id, this.accelerometer);
        }
        if (this.accelerometer == null) {
            return;
        }
        DeviceHandle handle = new DeviceHandle(DeviceType.GROVE_3AXIS_ACCELEROMETER, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.accelerometer), req.getDeviceAlias());
        this.deviceMappings.put(handle, this.accelerometer);
        if (!this.deviceHandles.containsKey(this.accelerometer)) {
            this.deviceHandles.put(this.accelerometer, new HashSet());
        }
        this.deviceHandles.get(this.accelerometer).add(handle);
        this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
    }

    private void registerBarometer(RegisterIoTDeviceRequest req, short protocolId) {
        if (this.barometer == null) {
            try {
                this.barometer = new GroveBarometer(this.pi4j);
            }
            catch (IOException e) {
                logger.error("Could not initialize the Barometer: ", (Throwable)e);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                this.barometer = null;
            }
            catch (Exception pe) {
                logger.error("Could not initialize the Barometer: ", (Throwable)pe);
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                this.barometer = null;
            }
            if (this.barometer == null) {
                return;
            }
            short id = (short)this.ids.incrementAndGet();
            this.deviceIds.put(this.barometer, id);
            this.deviceIdsMapping.put(id, this.barometer);
        }
        if (this.barometer == null) {
            return;
        }
        DeviceHandle handle = new DeviceHandle(DeviceType.GROVE_BAROMETER, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.barometer), req.getDeviceAlias());
        this.deviceMappings.put(handle, this.barometer);
        if (!this.deviceHandles.containsKey(this.barometer)) {
            this.deviceHandles.put(this.barometer, new HashSet());
        }
        this.deviceHandles.get(this.barometer).add(handle);
        this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
    }

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req, short protocolId) {
    }

    public void handleAccelerometerInputRequest(GetAccelerometerDataRequest req, short protocolId) {
        logger.debug("Received an GetAccelerometerDataRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof Grove3AxisAccelerometer && this.accelerometer != null) {
            switch (req.getInputType()) {
                case ACCELERATION_DATA: {
                    this.sendReply(new AccelerometerInputReply<Grove3AxisAccelerometer.AccelData>(h2, req.getInputType(), this.accelerometer.getAccelerationData()), protocolId);
                    break;
                }
                case ACCELERATION_SIMPLE: {
                    this.sendReply(new AccelerometerInputReply<float[]>(h2, req.getInputType(), this.accelerometer.getAcceleration()), protocolId);
                    break;
                }
                case XYZ: {
                    this.sendReply(new AccelerometerInputReply<int[]>(h2, req.getInputType(), this.accelerometer.getXYZ()), protocolId);
                    break;
                }
                default: {
                    this.sendReply(new AccelerometerInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.FAILED_MEASUREMENT, "Unsupported measurement on Grove3AxisAccelerometer"), protocolId);
                    break;
                }
            }
        } else {
            this.sendReply(new AccelerometerInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "Grove3AxisAccelerometer is not available to take measurements"), protocolId);
        }
    }

    public void handleGestureInputRequest(GetGestureRequest req, short protocolId) {
        logger.debug("Received a GetGestureRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (!(d instanceof GroveGestureDetector) || this.gesture == null) {
            this.sendReply(new GestureInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "GroveGestureDetector is not available to deteect activity"), protocolId);
            return;
        }
        this.sendReply(new GestureInputReply(h2, this.gesture.getGesture()), protocolId);
    }

    public void handleIoTPeriodicEventRequest(IoTPeriodicEventRequest req, short protocolId) {
    }

    public void handleReactiveGestureInputRequest(GetReactiveGestureRequest req, short protocolId) {
        logger.debug("Received a GetReactiveGestureRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (!(d instanceof GroveGestureDetector) || this.gesture == null) {
            this.sendReply(new GestureInputReply(req.getDeviceHandle().getDeviceType(), req.getDeviceHandle().getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "GroveGestureDetector is not available to deteect activity"), protocolId);
            return;
        }
        GestureListener gl = new GestureListener(this.gesture, req.getThreshold(), detectedGesture -> this.triggerNotification(new GestureNotification(h2, (GroveGestureDetector.PAJ7620GestureType)((Object)detectedGesture))));
        this.monitor.registerIoTListener(gl);
    }
}

