/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalInputProvider;
import com.pi4j.plugin.gpiod.provider.gpio.digital.GpioDDigitalOutputProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.iot.device.Device;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLcd;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLedMatrix;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceInterface;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.ErrorCode;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ClearDisplayRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.DisplayBarRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetDisplayColorRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowDisplayRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowTextRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.utils.I2CScanner;

public class I2COutputControlProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "I2COutputControlProtocol";
    public static final short PROTOCOL_ID = 4000;
    private static final Logger logger = LogManager.getLogger(I2COutputControlProtocol.class);
    private final Context pi4j;
    private GroveLedMatrix matrix;
    private GroveLcd lcd;
    private final I2CScanner scanner;
    private final AtomicInteger ids;
    private final HashMap<Device, Short> deviceIds;
    private final HashMap<Short, Device> deviceIdsMapping;
    private final HashMap<DeviceHandle, Device> deviceMappings;
    private final HashMap<Device, Set<DeviceHandle>> deviceHandles;

    public I2COutputControlProtocol() {
        super(PROTOCOL_NAME, (short)4000);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new RaspberryPiPlatform(this){

            @Override
            protected String[] getProviders() {
                return new String[0];
            }
        }).add(PiGpioDigitalInputProvider.newInstance(piGpio), PiGpioDigitalOutputProvider.newInstance(piGpio), PiGpioPwmProvider.newInstance(piGpio), PiGpioSerialProvider.newInstance(piGpio), PiGpioSpiProvider.newInstance(piGpio), GpioDDigitalInputProvider.newInstance(), GpioDDigitalOutputProvider.newInstance(), LinuxFsI2CProvider.newInstance()).build();
        this.scanner = I2CScanner.getInstance();
        this.ids = new AtomicInteger(0);
        this.deviceIds = new HashMap();
        this.deviceIdsMapping = new HashMap();
        this.deviceMappings = new HashMap();
        this.deviceHandles = new HashMap();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.registerRequestHandler((short)4000, this::handleRegisterIoTDeviceRequest);
        this.registerRequestHandler((short)4001, this::handleUnregisterIoTDeviceRequest);
        this.registerRequestHandler((short)8024, this::handleSetDisplayColorRequest);
        this.registerRequestHandler((short)8027, this::handleShowAnimationRequest);
        this.registerRequestHandler((short)8029, this::handleShowEmojiRequest);
        this.registerRequestHandler((short)8030, this::handleShowTextRequest);
        this.registerRequestHandler((short)8028, this::handleShowDisplayRequest);
        this.registerRequestHandler((short)8031, this::handleDisplayBarRequest);
        this.registerRequestHandler((short)8021, this::handleClearDisplayRequest);
    }

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req, short protocolId) {
        if (!req.getDeviceType().getDeviceInterface().equals((Object)DeviceInterface.I2C_OUT)) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.INVALID_INTERFACE, "Device interface is invalid, this protocol operates on I2C output devices"), protocolId);
            return;
        }
        Set<DeviceType> devices = this.scanner.getConnectedDevices();
        if (!devices.contains((Object)req.getDeviceType())) {
            this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_NOT_AVAILABLE, "Device is not connected"), protocolId);
            return;
        }
        DeviceHandle handle = null;
        switch (req.getDeviceType()) {
            case GROVE_LCD: {
                if (this.lcd == null) {
                    try {
                        this.lcd = new GroveLcd(this.pi4j);
                    }
                    catch (IOException e) {
                        logger.error("Could not initialize the LCD: ", (Throwable)e);
                        this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                        this.lcd = null;
                    }
                    catch (Exception pe) {
                        logger.error("Could not initialize the LCD: ", (Throwable)pe);
                        this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                        this.lcd = null;
                    }
                    if (this.lcd == null) {
                        return;
                    }
                    short id = (short)this.ids.incrementAndGet();
                    this.deviceIds.put(this.lcd, id);
                    this.deviceIdsMapping.put(id, this.lcd);
                    this.lcd.setText("Device initialized.");
                }
                if (this.lcd == null) {
                    return;
                }
                handle = new DeviceHandle(DeviceType.GROVE_LCD, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.lcd), req.getDeviceAlias());
                this.deviceMappings.put(handle, this.lcd);
                if (!this.deviceHandles.containsKey(this.lcd)) {
                    this.deviceHandles.put(this.lcd, new HashSet());
                }
                this.deviceHandles.get(this.lcd).add(handle);
                this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
                break;
            }
            case GROVE_LED_MATRIX: {
                if (this.matrix == null) {
                    try {
                        this.matrix = new GroveLedMatrix(this.pi4j);
                    }
                    catch (IOException e) {
                        logger.error("Could not initialize the LedMatrix: ", (Throwable)e);
                        this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                        this.matrix = null;
                    }
                    catch (Exception pe) {
                        logger.error("Could not initialize the LedMatrix: ", (Throwable)pe);
                        this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                        this.matrix = null;
                    }
                    if (this.matrix == null) {
                        return;
                    }
                    short id = (short)this.ids.incrementAndGet();
                    this.deviceIds.put(this.matrix, id);
                    this.deviceIdsMapping.put(id, this.matrix);
                    this.matrix.clearDisplay();
                    this.matrix.setAllColor((byte)-1, (byte)0, (byte)0);
                }
                if (this.matrix == null) {
                    return;
                }
                handle = new DeviceHandle(DeviceType.GROVE_LED_MATRIX, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.matrix), req.getDeviceAlias());
                this.deviceMappings.put(handle, this.matrix);
                if (!this.deviceHandles.containsKey(this.matrix)) {
                    this.deviceHandles.put(this.matrix, new HashSet());
                }
                this.deviceHandles.get(this.matrix).add(handle);
                this.sendReply(new RegisterIoTDeviceReply(handle), protocolId);
                break;
            }
            default: {
                this.sendReply(new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), ErrorCode.UNKNOWN_DEVICE, "Unknown DeviceType"), protocolId);
            }
        }
    }

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req, short protocolId) {
    }

    public void handleSetDisplayColorRequest(SetDisplayColorRequest req, short protocolId) {
        logger.debug("Received a SetDisplayColorRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.setAllColor((byte)req.getRed(), (byte)req.getGreen(), (byte)req.getBlue());
        }
    }

    public void handleDisplayBarRequest(DisplayBarRequest req, short protocolId) {
        logger.debug("Received a DisplayBarRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.displayColorBar(req.getLevel());
        }
    }

    public void handleClearDisplayRequest(ClearDisplayRequest req, short protocolId) {
        logger.debug("Received a ClearDisplayRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.clearDisplay();
        }
    }

    public void handleShowDisplayRequest(ShowDisplayRequest req, short protocolId) {
        logger.debug("Received a ShowDisplayRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.loadSnapshot(req.getDisplay());
        }
    }

    public void handleShowAnimationRequest(ShowAnimationRequest req, short protocolId) {
        logger.debug("Received a ShowAnimationRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.displayColorAnimation(req.getAnimation());
        }
    }

    public void handleShowEmojiRequest(ShowEmojiRequest req, short protocolId) {
        logger.debug("Received a ShowEmojiRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.displayEmoji(req.getEmoji());
        }
    }

    public void handleShowTextRequest(ShowTextRequest req, short protocolId) {
        logger.debug("Received a ShowTextRequest");
        DeviceHandle h2 = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h2.getDeviceID());
        if (d instanceof GroveLcd && this.lcd != null) {
            this.lcd.setText(req.getText());
        }
    }
}

